/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class SetV5DataItemIsProjected
extends Transformation {
    public SetV5DataItemIsProjected() {
        this.mName = "Set isProjected property on V5DataItem";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101015, 101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String dataItemName = SetV5DataItemIsProjected.getDataItemName(node);
        V5DataItem v5DataItem = this.getV5DataItem(node, dataItemName);
        v5DataItem.setIsProjected();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem;
        XQETrace xqeTrace = environment.getTrace();
        String dataItemName = SetV5DataItemIsProjected.getDataItemName(node);
        if (dataItemName != null && (v5DataItem = this.getV5DataItem(node, dataItemName)) != null && !v5DataItem.getIsProjected()) {
            this.traceNodeCondition(true, "The isProjected property will be set.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The isProjected property will NOT be set.", xqeTrace);
        return false;
    }

    public static String getDataItemName(IXQEQueryNode node) {
        int[] types;
        IXQEQueryNode[] ancestors;
        String dataItemName = null;
        if (node.getType() == 101015 && (ancestors = node.getAncestorsOfTypes(types = new int[]{101051, 101052, 101053})) != null && ancestors.length > 0) {
            dataItemName = ((V5DataItemRef)node).getDataItemRefProperty();
        }
        if (node.getType() == 101057) {
            dataItemName = ((V5ValueSet)node).getRefDataItemProperty();
        }
        return dataItemName;
    }

    private V5DataItem getV5DataItem(IXQEQueryNode node, String dataItemName) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (qrd == null) {
            return null;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)qrd.getAncestorOfType(101002);
        if (v5QuerySet == null) {
            return null;
        }
        String refQuery = qrd.getRefQueryProperty();
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        if (v5Query == null) {
            return null;
        }
        V5Selection v5Selection = v5Query.getV5Selection();
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(dataItemName);
        return v5DataItem;
    }
}

