/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class SplitFilterAtAND
extends Transformation {
    public SplitFilterAtAND() {
        this.mName = "SplitFilterAtAND.";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{101008, 101011};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode topExpression = node.getChild(0);
        this.decomposeFilter(environment, topExpression, node);
        node.detach();
    }

    private boolean decomposeFilter(PlanningEnvironment environment, IXQEQueryNode expressionNode, IXQEQueryNode originalFilterNode) {
        boolean isDecomposed = false;
        if (expressionNode.getType() != 201124 && expressionNode.getType() == 201003 && ((V5LogicalExpression)expressionNode).getSubType() == 0) {
            isDecomposed = true;
            for (IXQEQueryNode child : expressionNode.getChildren()) {
                this.decomposeFilter(environment, child, originalFilterNode);
            }
        }
        if (!isDecomposed) {
            V5QueryNode newV5Filter;
            if (originalFilterNode.getType() == 101008) {
                newV5Filter = (V5DetailFilter)environment.getNodeFactory().createNode(101008);
                newV5Filter.setPropertyValue("splitFilterAtAND", true);
                originalFilterNode.copyContentTo(environment.getNodeFactory(), newV5Filter);
                originalFilterNode.getParent().addChild(newV5Filter);
                IXQEQueryNode clonedExpr = environment.getNodeFactory().deepCopyNode(expressionNode);
                newV5Filter.addChild(clonedExpr);
            } else {
                newV5Filter = (V5SummaryFilter)environment.getNodeFactory().createNode(101011);
                newV5Filter.setPropertyValue("splitFilterAtAND", true);
                originalFilterNode.copyContentTo(environment.getNodeFactory(), newV5Filter);
                originalFilterNode.getParent().addChild(newV5Filter);
                IXQEQueryNode clonedExpr = environment.getNodeFactory().deepCopyNode(expressionNode);
                newV5Filter.addChild(clonedExpr);
                IXQEQueryNode[] levels = originalFilterNode.getChildrenOfType(101012);
                if (levels.length > 0) {
                    newV5Filter.addChild(environment.getNodeFactory().deepCopyNode(levels[0]));
                }
            }
        }
        return isDecomposed;
    }

    private boolean nodeContainsAND(IXQEQueryNode node) {
        IXQEQueryNode[] logicalExps;
        boolean containsAND = false;
        for (IXQEQueryNode logicalExp : logicalExps = node.getDescendantsOfType(201003, true)) {
            if (((V5LogicalExpression)logicalExp).getSubType() != 0 || logicalExp.getAncestorOfType(201018) != null) continue;
            containsAND = true;
        }
        return containsAND;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!this.nodeContainsAND(node)) {
            this.traceQueryCondition(false, "Filter does not contain a logical AND.", environment.getTrace());
            return false;
        }
        if (node instanceof V5DetailFilter && !((V5DetailFilter)node).getPostAutoAggregation() && RQPUtilities.hasAggregateInExpression(node)) {
            this.traceQueryCondition(false, "Detail filter with postAutoAggregation=false has aggregates in its expression.", environment.getTrace());
            return false;
        }
        return true;
    }
}

