/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.moser.util.ConvertModQueryToV5QueryUtil;
import com.cognos.xqe.transformation.v5.util.V5MultiModelsUtil;

public final class SwitchMetadataConnectionforExecuteValidateCommand
extends Transformation {
    public static final String SWITCH_METADATA_CONNECTION = "switchMetadataConnectionApplied";

    public SwitchMetadataConnectionforExecuteValidateCommand() {
        this.mName = "Switch the metadata connection fro execute and validate command";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QuerySet querySet = (V5QuerySet)node;
        Boolean bApplied = (Boolean)querySet.getPropertyValue(SWITCH_METADATA_CONNECTION);
        if (bApplied == Boolean.TRUE) {
            this.traceNodeCondition(false, "Switching MetadataConnection is applied.", trace);
            return false;
        }
        boolean b = false;
        IXQEQueryNode[] modQueries = querySet.getDescendantsOfType(101079, false);
        b = modQueries.length > 0 ? ConvertModQueryToV5QueryUtil.needToSwitchMetadataConnection(environment, querySet) : V5MultiModelsUtil.needToSwitchMetadataConnection(environment, querySet);
        if (!b) {
            this.traceNodeCondition(false, "no need to switch MetadataConnection.", trace);
            return false;
        }
        this.traceNodeCondition(true, "need to switch MetadataConnection.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node;
        querySet.setPropertyValue(SWITCH_METADATA_CONNECTION, Boolean.TRUE);
        IXQEQueryNode[] modQueries = querySet.getDescendantsOfType(101079, false);
        if (modQueries.length > 0) {
            ConvertModQueryToV5QueryUtil.switchMetadataConnection(environment, querySet);
        } else {
            V5MultiModelsUtil.switchMetadataConnection(environment, querySet);
        }
    }
}

