/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5CaseWhenClause;
import com.cognos.xqe.ast.v5Exp.V5LookupExpression;
import com.cognos.xqe.ast.v5Exp.V5LookupMapElement;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.ArrayList;
import java.util.List;

public final class TranslateV5LookupFunction
extends Transformation {
    public TranslateV5LookupFunction() {
        this.mName = "Translate lookup function to case expression.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201020};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5LookupExpression lookup = (V5LookupExpression)node;
        IXQEQueryNode[] children = lookup.getChildren();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        if (!this.validComparison(lookup, messageContext)) {
            V5LookupMapElement mapElement = (V5LookupMapElement)messageContext.get(messageContext.size() - 1);
            messageContext.add(node);
            XQEMessage message = new XQEMessage(XQEMessageKeys.EXE_InvalidComparison, V5ExpressionCheck.getFDSDataTypeForV5Expression(node.getChild(0)).toFDSKeyword(), V5ExpressionCheck.getFDSDataTypeForV5Expression(mapElement.getChild(0)).toFDSKeyword(), messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        V5CaseExpression caseExpression = (V5CaseExpression)factory.createNode(201018);
        caseExpression.setSubType(0);
        for (int i = 0; i < children.length; ++i) {
            if (i == 0 || i == children.length - 1) {
                caseExpression.addChild(children[i]);
                continue;
            }
            V5LookupMapElement mapElement = (V5LookupMapElement)children[i];
            V5CaseWhenClause whenClause = (V5CaseWhenClause)factory.createNode(201019);
            whenClause.addChildren(mapElement.getChildren(), 0);
            caseExpression.addChild(whenClause);
        }
        lookup.exchange(caseExpression);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query v5query = (V5Query)node.getAncestorOfType(101006);
        if (v5query != null && (v5query.isTabular() || v5query.isRelStyle())) {
            this.traceQueryCondition(false, "This is a relational query.", trace);
            return false;
        }
        return true;
    }

    private boolean validComparison(V5LookupExpression lookup, List<IXQEQueryNode> messageContext) {
        IXQEQueryNode[] children = lookup.getChildren();
        IDataType lhsDataType = lookup.getChildDataTypes()[0];
        for (int i = 1; i < children.length - 1; ++i) {
            V5LookupMapElement mapElement = (V5LookupMapElement)lookup.getChild(i);
            IDataType rhsDataType = mapElement.getChildDataTypes()[0];
            if (DataTypeComparator.areCompatibleDataTypes(lhsDataType, rhsDataType) && DataTypeComparator.isComparableTo(lhsDataType, rhsDataType)) continue;
            messageContext.add(lookup.getChild(0));
            messageContext.add(mapElement);
            return false;
        }
        return true;
    }
}

