/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserMetadataConnection;

public final class ValidateBoundIdentifier
extends Transformation {
    private static final int MIN_NAME_PARTS = 3;

    public ValidateBoundIdentifier() {
        this.mName = "Validate V5 bound model identifier.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IMetadata metadata;
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IDataType datatype = v5BoundID.getDataType();
        if (environment.getMetadataConnection() instanceof MoserMetadataConnection) {
            boolean bl = false;
        } else if (datatype == null && v5BoundID.getNameParts().length < 3 && !((metadata = v5BoundID.getMetadata()) instanceof IShortcut) && !(metadata instanceof MoserBaseMetadata)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidExpressionInItem, v5BoundID.getIdentifier());
        }
        v5BoundID.setIsValid();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (v5BoundID.isValid()) {
            this.traceQueryCondition(false, "The bound model identifier has already been validated.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The bound model identifier has not been validated.", trace);
        return true;
    }
}

