/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class BindV5ItemReferences
extends Transformation {
    public BindV5ItemReferences(int[] passNumbers) {
        this.mName = "Bind V5 multi-part identifier to a data item.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201030};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)node;
        V5Query currentQuery = (V5Query)node.getAncestorOfType(101006);
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, node);
        V5NameBinding nameBinding = new V5NameBinding(environment, rootQuerySet, currentQuery, null);
        IXQEQueryNode boundNode = nameBinding.bindMultiPartIdentifier(multiPartIdentifier);
        if (boundNode == null) {
            multiPartIdentifier.setAttemptedBindToV5Item();
        } else {
            multiPartIdentifier.exchange(boundNode, false);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getAncestorOfType(1002) != null) {
            this.traceQueryCondition(false, "This identifier is within a MDX Query, do not touch it.", trace);
            return false;
        }
        if (((V5MultiPartIdentifier)node).attemptedBindToV5Item()) {
            this.traceQueryCondition(false, "An attempt was already made to bind this identifier to a V5 item.", trace);
            return false;
        }
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query.getPropertyValue("isBound") != null) {
            return false;
        }
        V5Source source = (V5Source)query.getFirstChildByType(101007);
        if (null == source) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "BindV5SQLQueryItemReference requires source");
        }
        if (source.getNumberChildren() > 0 && source.getChild(0).getType() != 101016) {
            return false;
        }
        if (node.getParent().getType() != 201028) {
            status = true;
            this.traceQueryCondition(status, "This identifier is one to resolve.", trace);
        } else {
            this.traceQueryCondition(status, "This identifier is sub-part of a MUN, do nothing.", trace);
        }
        return status;
    }
}

