/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5InaccessibleMember;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.util.V5MunUtil;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEAbortGetParametersQueryException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.BaseExecutionEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.missingMember.MissingMember;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMissingMemberValidate;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.runtree.olap.querytemplates.MissingMemberValidateQuery;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.provider.powercube.SetPowerCubeMemberExternalName;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemoser.MoserHierarchy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class BindV5MemberUniqueName
extends Transformation {
    private static final String TMR_PART = "\\[TMR\\]\\.";
    private static final String TM_PART = "\\[TM\\]\\.";
    private static final String TMR_PHYSICAL_START = "[TMR].";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String STR_ALL = "all";
    public static final String DOT_SEPARATOR = "].[";

    public BindV5MemberUniqueName(int[] passNumbers) {
        this.mName = "Bind V5 Member Unique Name Identifier.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MemberUniqueName memberDetails = (V5MemberUniqueName)node;
        IMetadata md = memberDetails.getMetadata();
        IMetadata[] metadata = new IMetadata[1];
        V5BoundMemberUniqueName newNode = null;
        if (md != null && md.isDMR() && md instanceof MoserHierarchy) {
            newNode = BindV5MemberUniqueName.convertSimplerV5MemberUniqueNameToV5BoundMemberUniqueName(memberDetails, environment);
        } else {
            newNode = BindV5MemberUniqueName.convertV5MemberUniqueNameToV5BoundMemberUniqueName(memberDetails, environment, metadata);
            if (newNode == null && memberDetails.getMetadata() instanceof IQueryItemOfQuerySubject) {
                return;
            }
        }
        if (newNode != null) {
            RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
            IXQEQueryNode dataItem = memberDetails.getAncestorOfType(101003);
            if (dataItem != null) {
                memberDetails.setPropertyValue("dataItemName", dataItem.getPropertyValue("name"));
                reqEnv.addMun(memberDetails, memberDetails.getNativeName());
            } else {
                String contextName = null;
                if (memberDetails.getAncestorOfType(101008) != null) {
                    contextName = "detailFilter";
                } else if (memberDetails.getAncestorOfType(101011) != null) {
                    contextName = "summaryFilter";
                } else if (memberDetails.getAncestorOfType(101010) != null) {
                    contextName = "slicer";
                }
                if (contextName != null) {
                    memberDetails.setPropertyValue("dataItemName", contextName);
                    reqEnv.addMun(memberDetails, memberDetails.getNativeName());
                }
            }
            node.exchange(newNode, false);
        } else if (metadata[0] != null && metadata[0].getObjectType() == MetadataType.HIERARCHY) {
            IXQEQueryNode parentNode = node.getParent();
            if (parentNode.getType() != 201101 || parentNode.getType() == 201101 && parentNode.getNumberChildren() == 1) {
                XQENodeFactory nodeFactory = environment.getNodeFactory();
                V5InaccessibleMember inaccessibleMember = (V5InaccessibleMember)nodeFactory.createNode(201139);
                IHierarchy hierarchy = (IHierarchy)metadata[0];
                V5BoundModelIdentifier modelHierarchy = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
                modelHierarchy.setMetadata(hierarchy);
                modelHierarchy.setIdentifier(hierarchy.getUniqueName());
                inaccessibleMember.addChild(modelHierarchy);
                inaccessibleMember.setNativeName(memberDetails.getNativeName());
                node.exchange(inaccessibleMember, false);
            } else {
                node.detach();
            }
        }
    }

    private static V5BoundMemberUniqueName convertSimplerV5MemberUniqueNameToV5BoundMemberUniqueName(V5MemberUniqueName memberDetails, PlanningEnvironment environment) {
        MoserHierarchy hier = (MoserHierarchy)memberDetails.getMetadata();
        String logical = memberDetails.getLogical();
        ILevel level = null;
        String externalMUN = null;
        if (STR_ALL.equals(logical)) {
            level = hier.getLevel(0);
            externalMUN = UniqueNameGenerator.createSingleNamePart(STR_ALL);
        } else {
            String[] parts = UniqueNameParser.parseNoThrow(logical);
            if (parts != null) {
                level = hier.getLevel(parts.length);
                externalMUN = UniqueNameGenerator.createSingleNamePart(STR_ALL);
                for (String s : parts) {
                    externalMUN = UniqueNameGenerator.appendUniqueName(externalMUN, s);
                }
            }
        }
        if (level == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidMUN, (String)memberDetails.getPropertyValue("physical"));
        }
        String normalizedMUN = level.getV5UniqueName() + "->" + externalMUN;
        memberDetails.setNativeName(normalizedMUN);
        XQENodeFactory nf = environment.getNodeFactory();
        V5BoundMemberUniqueName v5BoundMemberUniqueName = (V5BoundMemberUniqueName)nf.createNode(201117);
        v5BoundMemberUniqueName.setExternalMemberUniqueName(externalMUN);
        v5BoundMemberUniqueName.setLevel(level);
        v5BoundMemberUniqueName.setNativeName(memberDetails.getNativeName());
        v5BoundMemberUniqueName.setLogical(externalMUN);
        return v5BoundMemberUniqueName;
    }

    public static V5BoundMemberUniqueName convertV5MemberUniqueNameToV5BoundMemberUniqueName(V5MemberUniqueName memberDetails, PlanningEnvironment environment, IMetadata[] metadata) {
        ILevel level = BindV5MemberUniqueName.bindLevelUniqueName(memberDetails, environment, metadata);
        if (level == null || V5MunUtil.isMunBindingFailed(memberDetails)) {
            return null;
        }
        return BindV5MemberUniqueName.createBoundMUNFromV5MUNAndLevel(memberDetails, environment, level);
    }

    public static V5BoundMemberUniqueName createBoundMUNFromV5MUNAndLevel(V5MemberUniqueName memberDetails, PlanningEnvironment environment, ILevel level) {
        String newExternalMUN;
        String providerUniqueName;
        String[] munParts;
        if (level == null) {
            return null;
        }
        String providerCode = level.getHierarchy().getDimension().getCube().getModelDataSource().getInterface();
        if (DataSourceTypeEnum.isTMR(providerCode)) {
            String physical = memberDetails.getPhysical();
            String tmPart = "[TM]";
            if (physical.contains("[TM]") || physical.contains(".[@MEMBER]")) {
                physical = physical.replaceFirst(TM_PART, TMR_PART);
                physical = physical.replaceFirst("\\.\\[@MEMBER\\]", "");
                memberDetails.setPhysical(physical);
            }
        }
        XQENodeFactory nf = environment.getNodeFactory();
        V5BoundMemberUniqueName v5BoundMemberUniqueName = (V5BoundMemberUniqueName)nf.createNode(201117);
        String externalMUN = V5MunUtil.getExternalMemberUniqueName(memberDetails, false);
        if (DataSourceTypeEnum.isTMR(providerCode) && (munParts = UniqueNameParser.parseNoThrow(externalMUN)) == null) {
            externalMUN = memberDetails.getPhysical().replaceFirst(TMR_PART, "");
        }
        if ((providerUniqueName = memberDetails.getProviderUniqueName()) != null) {
            externalMUN = providerUniqueName;
        }
        if (providerUniqueName == null && externalMUN != null && level.getHierarchy().getDimension().getCube() != null && (DataSourceTypeEnum.isPowerCube(providerCode) || DataSourceTypeEnum.isTM1(providerCode) || DataSourceTypeEnum.isROLAP(providerCode)) && (newExternalMUN = V5MunUtil.getExternalMUNWithEscapedSquareBrackets(memberDetails, false)) != null) {
            externalMUN = newExternalMUN;
        }
        v5BoundMemberUniqueName.setExternalMemberUniqueName(externalMUN);
        v5BoundMemberUniqueName.setLevel(level);
        v5BoundMemberUniqueName.setNativeName(memberDetails.getNativeName());
        if (memberDetails.getLogical() != null) {
            v5BoundMemberUniqueName.setLogical(memberDetails.getLogical());
        }
        return v5BoundMemberUniqueName;
    }

    private static ILevel bindLevelUniqueName(V5MemberUniqueName memberDetails, PlanningEnvironment environment, IMetadata[] metadata) {
        String lun = memberDetails.getModel();
        IMetadata metaData = memberDetails.getMetadata();
        if (metaData == null) {
            V5NameBinding nameBinding = new V5NameBinding(environment);
            metaData = nameBinding.bindModelIdentifier(lun, false);
            if (metaData == null) {
                V5MunUtil.setPropertyMUNBinding(memberDetails, false);
            } else if (metaData instanceof IQueryItemOfQuerySubject) {
                memberDetails.setMetadata(metaData);
                return null;
            }
        }
        metadata[0] = metaData;
        IHierarchy hierarchy = null;
        IMetadata newMetaData = null;
        ICube cube = null;
        if (metaData != null && !metaData.isDMR()) {
            boolean forceMUNValidation;
            hierarchy = metaData.getObjectType() == MetadataType.HIERARCHY ? (IHierarchy)metaData : ((ILevel)metaData).getHierarchy();
            if (hierarchy.getDimension() != null && !hierarchy.getDimension().isShareable() && environment.getCubeName() == null && (cube = hierarchy.getDimension().getCube()) != null) {
                environment.setCubeName(cube.getName());
            }
            if (cube == null) {
                cube = hierarchy.getDimension().getCube();
            }
            IModelDataSource modelDataSource = cube.getModelDataSource();
            String providerCode = MetadataUtil.getProviderCode(cube);
            IDataSourceCapabilities capabilities = environment.getCapabilities(providerCode);
            boolean queryProviderForLevels = capabilities != null && capabilities.isSupported("queryProviderForLevels");
            boolean bl = forceMUNValidation = capabilities != null && capabilities.isSupported("forceMUNvalidationAtExecution") && !((RequestEnvironment)environment.getRequestEnvironment()).isMetadataRequest();
            if (hierarchy.isParentChild() || queryProviderForLevels || forceMUNValidation) {
                boolean usesLocalEngine = true;
                if (!(cube instanceof CubeWrapper) && modelDataSource.isMultidimensional() && !DataSourceTypeEnum.isROLAP(providerCode)) {
                    usesLocalEngine = capabilities.isSupported("v5.useLocalOLAP");
                }
                if (usesLocalEngine && DataSourceTypeEnum.isTM1(providerCode) && memberDetails.getParent() != null) {
                    V5Query v5Query = (V5Query)memberDetails.getAncestorOfType(101006);
                    String queryProcessing = null;
                    if (v5Query != null) {
                        queryProcessing = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName());
                    }
                    if (queryProcessing != null) {
                        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                        boolean bl2 = usesLocalEngine = !queryProcessing.equals("limitedLocal") && !queryProcessing.equals("minimizeLocal");
                        if (usesLocalEngine) {
                            boolean bl3 = usesLocalEngine = !config.getBooleanProperty("queryPlanning.enableTM1_101CompatibilityMode[@value]", false) || !queryProcessing.equals("databaseOnly");
                        }
                    }
                }
                if (DataSourceTypeEnum.isTMR(providerCode)) {
                    usesLocalEngine = true;
                }
                if (usesLocalEngine) {
                    RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
                    newMetaData = DataSourceTypeEnum.isTM(providerCode) && requestEnvironment.isGetParametersRequest() && requestEnvironment.getRequestParameters().hasUnresolvedParameters() ? null : BindV5MemberUniqueName.getLevelViaSecondaryV5Query(memberDetails, environment, hierarchy);
                } else {
                    newMetaData = BindV5MemberUniqueName.getLevelViaSecondaryCustomQuery(memberDetails, environment, hierarchy);
                }
                if (hierarchy.isParentChild() || queryProviderForLevels) {
                    return (ILevel)newMetaData;
                }
            }
        }
        if (metaData != null && metaData.getObjectType() != MetadataType.LEVEL) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidMUN, (String)memberDetails.getPropertyValue("physical"));
        }
        return (ILevel)metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static IMetadata getLevelViaSecondaryV5Query(V5MemberUniqueName v5MemberUniqueName, PlanningEnvironment environment, IHierarchy hierarchy) {
        IMember theMember;
        String providerCode;
        PlanningEnvironment subQueryEnvironment;
        ILevel metaData;
        block29: {
            ExecutionEnvironmentContext env;
            block27: {
                metaData = null;
                subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironmentWithoutTracing((ExecutionEnvironment)environment.getExecutionEnvironment(), environment);
                ILevel tempLevel = hierarchy.getLevel(0);
                V5BoundMemberUniqueName v5BoundMemberUniqueName = BindV5MemberUniqueName.createBoundMUNFromV5MUNAndLevel(v5MemberUniqueName, subQueryEnvironment, tempLevel);
                ICube cube = hierarchy.getDimension().getCube();
                providerCode = MetadataUtil.getProviderCode(cube);
                HashMap<String, Object> queryProperties = null;
                V5QuerySet v5QuerySet = null;
                if (DataSourceTypeEnum.isROLAP(providerCode)) {
                    queryProperties = new HashMap<String, Object>();
                    queryProperties.put("calculatedDefaultMembersMaskList", new ArrayList());
                }
                if (DataSourceTypeEnum.isTM(providerCode)) {
                    if (null == queryProperties) {
                        queryProperties = new HashMap();
                    }
                    queryProperties.put("skipParametersValidation", true);
                }
                v5QuerySet = V5SubQueryBuilder.createSingleMemberQuery(v5BoundMemberUniqueName, subQueryEnvironment, queryProperties);
                RequestEnvironment subRequestEnvironment = (RequestEnvironment)subQueryEnvironment.getRequestEnvironment();
                BaseExecutionEnvironment execEnv = null;
                env = null;
                XDataContext dataContext = null;
                theMember = null;
                try {
                    PlannedV5QuerySet plannedQuery = QueryPlanner.getInstance().planQuery(v5QuerySet, subQueryEnvironment);
                    subQueryEnvironment.setPlanningActive(subRequestEnvironment);
                    execEnv = (ExecutionEnvironment)subQueryEnvironment.getExecutionEnvironment();
                    env = ExecutionEnvironmentContext.enter(execEnv);
                    dataContext = execEnv.pushDataContext();
                    IHybridResultSet hybridResultSet = V5SubQueryBuilder.executeSubQuery(dataContext, plannedQuery);
                    try {
                        theMember = V5SubQueryBuilder.getMemberFromSubQuery(hybridResultSet);
                    }
                    catch (Throwable t) {
                        throw t;
                    }
                    finally {
                        hybridResultSet.release();
                    }
                    if (execEnv == null || dataContext == null) break block27;
                }
                catch (XQEAbortGetParametersQueryException e) {
                    IMetadata hybridResultSet = null;
                    return hybridResultSet;
                }
                catch (Throwable t) {
                    block28: {
                        mErrorLogger.log(t);
                        if (!((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
                            IDataSourceCapabilities capabilities = environment.getCapabilities(providerCode);
                            boolean forceMUNValidation = capabilities != null && capabilities.isSupported("forceMUNvalidationAtExecution") && !((RequestEnvironment)environment.getRequestEnvironment()).isMetadataRequest();
                            String providerMun = V5MunUtil.getExternalMemberUniqueName(v5MemberUniqueName, false);
                            if (forceMUNValidation) {
                                throw new XQERuntimeException(XQEMessageKeys.PLN_MissingMembers, providerMun);
                            }
                            int aSeverity = 1;
                            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, providerMun));
                        } else {
                            Map<String, MissingMember> missingMemberList = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestMissingMembers();
                            XMissingMemberValidate.collectMissingMembers(v5MemberUniqueName, "", "", missingMemberList);
                        }
                        if (execEnv == null || dataContext == null) break block28;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        execEnv.popDataContext(dataContext);
                    }
                    if (env != null) {
                        env.exit();
                    }
                    break block29;
                }
                finally {
                    if (execEnv != null && dataContext != null) {
                        execEnv.popDataContext(dataContext);
                    }
                    if (env != null) {
                        env.exit();
                    }
                }
                execEnv.popDataContext(dataContext);
            }
            if (env != null) {
                env.exit();
            }
        }
        subQueryEnvironment.setPlanningInactive();
        if (theMember == null) {
            if (!((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
                IDataSourceCapabilities capabilities = environment.getCapabilities(providerCode);
                boolean forceMUNValidation = capabilities != null && capabilities.isSupported("forceMUNvalidationAtExecution") && !((RequestEnvironment)environment.getRequestEnvironment()).isMetadataRequest();
                String providerMun = V5MunUtil.getExternalMemberUniqueName(v5MemberUniqueName, false);
                if (forceMUNValidation) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_MissingMembers, providerMun);
                }
            }
            int aSeverity = 1;
            String providerMun = V5MunUtil.getExternalMemberUniqueName(v5MemberUniqueName, false);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, providerMun));
            return null;
        }
        ILevel memberLevel = theMember.getLevel();
        if (DataSourceTypeEnum.isTMR(providerCode) && !((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
            StringBuffer sb = new StringBuffer(TMR_PHYSICAL_START);
            sb.append(theMember.getUniqueName());
            v5MemberUniqueName.setPhysical(sb.toString());
        }
        metaData = hierarchy.getLevel(memberLevel.getIndex());
        return metaData;
    }

    private static IMetadata getLevelViaSecondaryCustomQuery(V5MemberUniqueName v5MemberUniqueName, PlanningEnvironment environment, IHierarchy hierarchy) {
        ILevel metaData = null;
        ICube cube = hierarchy.getDimension().getCube();
        String providerCode = MetadataUtil.getProviderCode(cube);
        boolean isForXML = DataSourceTypeEnum.isTM1(providerCode) || DataSourceTypeEnum.isPowerCube(providerCode);
        String providerMun = null;
        if (DataSourceTypeEnum.isTM1(providerCode)) {
            providerMun = V5MunUtil.getExternalMUNWithEscapedSquareBrackets(v5MemberUniqueName, isForXML);
        } else {
            providerMun = V5MunUtil.getExternalMemberUniqueName(v5MemberUniqueName, isForXML);
            if (DataSourceTypeEnum.isEssbase(providerCode)) {
                if (providerMun.lastIndexOf(DOT_SEPARATOR) >= 0) {
                    try {
                        String[] parts = UniqueNameParser.parse(providerMun);
                        if (parts.length > 2) {
                            providerMun = UniqueNameGenerator.createUniqueName(parts[parts.length - 2], parts[parts.length - 1]);
                        }
                    }
                    catch (UniqueNameParserException e) {
                        XQEDebugLog.err.println("Error parsing essbase unique name " + providerMun);
                    }
                }
            } else if (DataSourceTypeEnum.isPowerCube(providerCode)) {
                providerMun = SetPowerCubeMemberExternalName.buildPowerCubeMemberExternalName(providerMun, hierarchy, true);
            }
        }
        MissingMemberValidateQuery mMValidateQuery = (MissingMemberValidateQuery)CustomQueryFactory.createCustomQuery("MissingMemberValidateQuery", cube);
        mMValidateQuery.setMemberName(providerMun);
        mMValidateQuery.setEscapeParameters(false);
        try {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
            ExecutionEnvironmentContext env = ExecutionEnvironmentContext.enter(execEnv);
            XDataContext dataContext = execEnv.pushDataContext();
            IMember theMember = null;
            try {
                IHybridResultSet hybridResultSet = mMValidateQuery.execute(dataContext);
                try {
                    theMember = V5SubQueryBuilder.getMemberFromSubQuery(hybridResultSet);
                }
                catch (Throwable t) {
                    throw t;
                }
                finally {
                    hybridResultSet.release();
                }
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                execEnv.popDataContext(dataContext);
                env.exit();
            }
            if (theMember == null) {
                int aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, providerMun));
                return null;
            }
            IDataSourceCapabilities capabilities = environment.getCapabilities(providerCode);
            if (capabilities != null && capabilities.isSupported("queryProviderForLevels")) {
                v5MemberUniqueName.setProviderUniqueName(theMember.getUniqueName());
            }
            ILevel memberLevel = theMember.getLevel();
            metaData = hierarchy.getLevel(memberLevel.getIndex());
        }
        catch (Throwable t) {
            mErrorLogger.log(t);
            if (!((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
                boolean forceMUNValidation;
                IDataSourceCapabilities capabilities = environment.getCapabilities(providerCode);
                boolean bl = forceMUNValidation = capabilities != null && capabilities.isSupported("forceMUNvalidationAtExecution") && !((RequestEnvironment)environment.getRequestEnvironment()).isMetadataRequest();
                if (forceMUNValidation) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_MissingMembers, providerMun);
                }
                int aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, providerMun));
            }
            Map<String, MissingMember> missingMemberList = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestMissingMembers();
            XMissingMemberValidate.collectMissingMembers(v5MemberUniqueName, "", "", missingMemberList);
        }
        return metaData;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5MemberUniqueName memberDetails = (V5MemberUniqueName)node;
        if (V5MunUtil.isMunBindingFailed(memberDetails)) {
            this.traceNodeCondition(false, "The V5MemberUniqueName node binding failed.", trace);
            return false;
        }
        if (memberDetails.getMetadata() instanceof IQueryItemOfQuerySubject) {
            this.traceNodeCondition(false, "BindV5ValueUniqueName should be applied.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The node is a valid V5MemberUniqueName node that can be converted to V5BoundMemberUniqueName.", trace);
        return true;
    }
}

