/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RMModelQueryAsView;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.binding.BindIdentifierNotFoundException;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;
import com.cognos.xqe.util.symboltable.SymbolTableForRMQuery;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserEmbeddedModuleWrapper;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserParameterUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class BindV5MultiPartIdentifierToModel
extends Transformation {
    private static final String SAPMUN = "[MEMBER_UNIQUE_NAME]";
    private static final String STR_DOT = ".";
    private static final String STR_ESCAPE_DOT = "\\.";

    public BindV5MultiPartIdentifierToModel(int[] passNumbers) {
        this.mName = "Bind V5 multi-part identifier to the model.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201030};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)node;
        BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, multiPartIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V5BoundModelIdentifier bindV5MultiPartIdentifierToModel(PlanningEnvironment environment, V5MultiPartIdentifier multiPartIdentifier) {
        RMQueryItem rmqi;
        MetadataContext context;
        IMetadata metadata;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String identifier = multiPartIdentifier.getIdentifier();
        RMQuery rmQuery = (RMQuery)multiPartIdentifier.getAncestorOfCategory(801026);
        RMEmbeddedFilterList embeddedFilterList = (RMEmbeddedFilterList)multiPartIdentifier.getAncestorOfType(801036);
        boolean loadQSForValidate = false;
        boolean loadQIForValidate = false;
        IQuerySubject qs = null;
        MetadataConnectionContext mc = null;
        String modelPath = null;
        V5Query v5QueryRefByQRD = null;
        MDXQuery mdxQuery = (MDXQuery)multiPartIdentifier.getAncestorOfCategory(1002);
        if (mdxQuery != null) {
            v5QueryRefByQRD = mdxQuery.getRefV5Query();
        }
        try {
            RMQueryItem rmQueryItem = (RMQueryItem)multiPartIdentifier.getAncestorOfType(801033);
            IMetadata self = null;
            if (rmQueryItem != null) {
                self = rmQueryItem.getQueryItem();
            }
            if (rmQuery != null) {
                boolean bindOnlyToQuerySubject = null != embeddedFilterList;
                environment.pushSymbolTable(new SymbolTableForRMQuery(environment, rmQuery, self, bindOnlyToQuerySubject));
                environment.getSymbolTableStack().pushSelf(self);
            } else if (embeddedFilterList != null) {
                qs = embeddedFilterList.getQuerySubject();
                if (qs != null) {
                    if (mc == null && environment.isMultiModelForQueryEnabled()) {
                        MetadataConnection conn = qs.getConnection();
                        modelPath = conn.getModelName();
                        mc = environment.pushMetadataConnectionContext(modelPath);
                    }
                    environment.pushSymbolTable(new SymbolTableForQS(qs, null, false));
                }
            } else if (environment.getRoot() != null) {
                IXQEQueryNode parent = multiPartIdentifier.getAncestorOfType(101003);
                if (parent == null) {
                    parent = multiPartIdentifier.getAncestorOfType(101008);
                }
                IMetadata contextMD = (IMetadata)multiPartIdentifier.getPropertyValue("contextMetadata");
                if (parent != null) {
                    String contextIdentifier = (String)parent.getPropertyValue("contextIdentifier");
                    if (contextIdentifier != null) {
                        MetadataConnection connection;
                        V5Query query;
                        if (mc == null && environment.isMultiModelForQueryEnabled() && (query = RQPNode.getV5Query(multiPartIdentifier)) != null) {
                            modelPath = query.getMetadataPath();
                            mc = environment.pushMetadataConnectionContext(modelPath);
                        }
                        if ((connection = environment.getMetadataConnection()) instanceof MoserMetadataConnection) {
                            MoserModule module = ((MoserMetadataConnection)connection).getModule();
                            String moduleId = module.getUniqueName();
                            String qsIdentifier = null;
                            String qiIdentifier = null;
                            String[] parts = contextIdentifier.split(STR_ESCAPE_DOT);
                            if (parts.length > 1) {
                                qsIdentifier = module instanceof MoserEmbeddedModuleWrapper ? parts[parts.length - 2] : moduleId + STR_DOT + parts[parts.length - 2];
                                qiIdentifier = qsIdentifier + STR_DOT + parts[parts.length - 1];
                            } else if (parts.length == 1 && !contextIdentifier.equals(moduleId)) {
                                qsIdentifier = module instanceof MoserEmbeddedModuleWrapper ? contextIdentifier : moduleId + STR_DOT + contextIdentifier;
                            }
                            if (qsIdentifier != null) {
                                loadQSForValidate = BindV5MultiPartIdentifierToModel.loadQSScopeToSymbolStack(environment, qsIdentifier, qiIdentifier);
                            }
                            if (qiIdentifier != null) {
                                loadQIForValidate = BindV5MultiPartIdentifierToModel.loadQISelfOnSymbolStack(environment, qiIdentifier);
                            }
                        }
                    } else {
                        IQuerySubject contextQS = BindV5MultiPartIdentifierToModel.setMetadataContext(environment, (IMetadata)parent.getPropertyValue("contextMetadata"));
                        if (contextQS != null) {
                            qs = contextQS;
                            if (mc == null && environment.isMultiModelForQueryEnabled()) {
                                MetadataConnection conn = qs.getConnection();
                                modelPath = conn.getModelName();
                                mc = environment.pushMetadataConnectionContext(modelPath);
                            }
                        }
                    }
                } else {
                    IQuerySubject contextQS = BindV5MultiPartIdentifierToModel.setMetadataContext(environment, contextMD);
                    if (contextQS != null) {
                        qs = contextQS;
                        if (mc == null && environment.isMultiModelForQueryEnabled()) {
                            MetadataConnection conn = qs.getConnection();
                            modelPath = conn.getModelName();
                            mc = environment.pushMetadataConnectionContext(modelPath);
                        }
                    }
                }
            }
            if (mc == null && environment.isMultiModelForQueryEnabled()) {
                V5Query query = null;
                query = RQPNode.getV5Query(multiPartIdentifier);
                if (v5QueryRefByQRD != null && v5QueryRefByQRD.getMetadataPath() != null) {
                    query = v5QueryRefByQRD;
                }
                if (query != null) {
                    modelPath = query.getMetadataPath();
                    mc = environment.pushMetadataConnectionContext(modelPath);
                }
            }
            V5NameBinding nameBinding = new V5NameBinding(environment);
            metadata = nameBinding.bindModelIdentifier(identifier, true);
        }
        finally {
            if (rmQuery != null) {
                environment.popSymbolTable();
                environment.getSymbolTableStack().popSelf();
            } else if (qs != null) {
                environment.popSymbolTable();
            } else if (loadQSForValidate) {
                environment.popSymbolTable();
                if (loadQIForValidate) {
                    environment.getSymbolTableStack().popSelf();
                }
            }
            if (mc != null) {
                mc.close();
            }
        }
        if (metadata == null) {
            ResponseMessage msg = null;
            if ("validateAll".equals(((RequestEnvironment)environment.getRequestEnvironment()).getOperationName())) {
                IXQEQueryNode dataItem = multiPartIdentifier.getAncestorOfType(101003);
                if (dataItem == null) {
                    dataItem = multiPartIdentifier.getAncestorOfType(101008);
                }
                if (dataItem != null) {
                    String moduleLocation = (String)dataItem.getPropertyValue("moduleLocation");
                    while (moduleLocation == null && (dataItem = dataItem.getAncestorOfType(101003)) != null) {
                        moduleLocation = (String)dataItem.getPropertyValue("moduleLocation");
                    }
                    if (moduleLocation != null) {
                        String diName = (String)dataItem.getPropertyValue("name");
                        IMessageKey.Param2 msgParam = XQEMessageKeys.MSR_ColumnMissingRef;
                        if (moduleLocation.contains("./calculation[")) {
                            msgParam = XQEMessageKeys.MSR_CalculationMissingRef;
                        } else if (moduleLocation.contains("/filter[")) {
                            msgParam = XQEMessageKeys.MSR_FilterMissingRef;
                        }
                        msg = new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, msgParam, diName, identifier);
                    }
                }
            }
            if (msg == null) {
                msg = new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.V5_IdentifierNotFound, identifier);
            }
            ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(msg, multiPartIdentifier, environment.getRoot());
            if (!((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest() && !environment.isMultiModelForQueryEnabled()) {
                throw new BindIdentifierNotFoundException(identifier);
            }
            if (environment.isMultiModelForQueryEnabled() && !((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest() && !((RequestEnvironment)environment.getRequestEnvironment()).isGetParametersRequest()) {
                throw new BindIdentifierNotFoundException(identifier);
            }
            multiPartIdentifier.setBindToModelFailed();
            return null;
        }
        if (metadata.getObjectType() == MetadataType.QUERY_ITEM && metadata instanceof IQueryItemOfLevel) {
            IQueryItemOfLevel queryItem = (IQueryItemOfLevel)metadata;
            ICube cube = queryItem.getDimension().getCube();
            if (multiPartIdentifier.createdFromQueryItemOfQuerySubject() && queryItem.getUniqueName().equals(SAPMUN) && DataSourceTypeEnum.isSAPBW(cube.getModelDataSource().getInterface())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedSAPModel);
            }
        }
        if ((context = (MetadataContext)multiPartIdentifier.getPropertyValue("metadataContext")) != null) {
            metadata = context.wrapMetadata(metadata);
        }
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        newNode.setMetadata(metadata);
        if (!"validateAll".equals(((RequestEnvironment)environment.getRequestEnvironment()).getOperationName()) && (metadata instanceof MoserQueryItem || metadata instanceof MoserCalculation)) {
            newNode.setIdentifier(MoserParameterUtil.getIdForExpression(metadata, identifier));
        } else {
            newNode.setIdentifier(identifier);
        }
        if (multiPartIdentifier.getBooleanPropertyValue("v5QueryIdentifier") != null) {
            newNode.setPropertyValue("v5QueryIdentifier", Boolean.TRUE);
        }
        if (multiPartIdentifier.getParent() != null) {
            multiPartIdentifier.exchange(newNode, false);
        } else {
            multiPartIdentifier.detach();
        }
        if (rmQuery instanceof RMModelQueryAsView && embeddedFilterList != null && (rmqi = rmQuery.getRMQueryItem(newNode)) != null) {
            rmqi.setPropertyValue("refByEmbeddedFiltInMQS", "true");
        }
        return newNode;
    }

    private static IQuerySubject setMetadataContext(PlanningEnvironment environment, IMetadata md) {
        if (!(md instanceof MoserCalculation)) {
            return null;
        }
        IMetadata p = ((MoserCalculation)md).getParentObject();
        IQuerySubject qs = null;
        if (p instanceof IQuerySubject) {
            qs = (IQuerySubject)p;
        } else if (p instanceof MoserQueryItem) {
            MoserQueryItem qItem = (MoserQueryItem)p;
            qs = qItem.getQuerySubject();
        }
        if (qs == null) {
            return null;
        }
        SymbolTableForQS t = new SymbolTableForQS(qs, null, true);
        t.setScope(((MoserCalculation)md).getScopesForExpr());
        environment.pushSymbolTable(t);
        return qs;
    }

    private static boolean loadQSScopeToSymbolStack(PlanningEnvironment environment, String qsIdentifier, String qiIdentifier) {
        boolean status = false;
        MetadataConnection mc = environment.getMetadataConnection();
        IMetadata md = null;
        IMetadata mdQI = null;
        if (mc instanceof MoserMetadataConnection) {
            md = ((MoserMetadataConnection)mc).bindQuerySubjectReference(qsIdentifier);
            if (qiIdentifier != null) {
                mdQI = mc.bindMetadataReference(qiIdentifier);
            }
        } else {
            md = mc.bindMetadataReference(qsIdentifier);
        }
        if (md != null && md instanceof IQuerySubject) {
            environment.pushSymbolTable(new SymbolTableForQS((IQuerySubject)md, mdQI, false));
            status = true;
        }
        return status;
    }

    private static boolean loadQISelfOnSymbolStack(PlanningEnvironment environment, String qiIdentifier) {
        boolean status = false;
        IMetadata md = environment.getMetadataConnection().bindMetadataReference(qiIdentifier);
        if (md != null && md instanceof IQueryItem) {
            environment.getSymbolTableStack().pushSelf(md);
            status = true;
        }
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((V5MultiPartIdentifier)node).hasBindToModelFailed()) {
            return false;
        }
        if (node.getAncestorOfType(101072) != null) {
            this.traceQueryCondition(true, "This identifier is within a prePlan query, must be bound.", trace);
            return true;
        }
        if (node.getAncestorOfType(1002) != null) {
            this.traceQueryCondition(false, "This identifier is within a MDX Query, do not touch it.", trace);
            return false;
        }
        if (node.getParent() != null && node.getParent().getType() == 201028) {
            this.traceQueryCondition(false, "This identifier is sub-part of a MUN, do nothing.", trace);
            return false;
        }
        this.traceQueryCondition(true, "This identifier can be bound to the model.", trace);
        return true;
    }
}

