/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryItem;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class BindV5QueryItem
extends Transformation {
    private static final String PROP_BOUND_QUERY_ITEMS = "queryItemsBound";

    public BindV5QueryItem() {
        this.mName = "Augment a V5 query item with data type information.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{101018};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] queryItems;
        V5QueryOperation queryOperation = (V5QueryOperation)node;
        IXQEQueryNode mainQuery = queryOperation.getAncestorOfType(101006);
        IXQEQueryNode[] queryRefs = queryOperation.getReferencedV5Queries(environment);
        for (IXQEQueryNode qItem : queryItems = queryOperation.getDescendantsOfType(101022, false)) {
            this.bindQueryItem((V5QueryItem)qItem, mainQuery, queryOperation, queryRefs, environment);
        }
        this.setBound(queryOperation);
    }

    private void bindQueryItem(V5QueryItem qItem, IXQEQueryNode mainQuery, V5QueryOperation queryOperation, IXQEQueryNode[] queryRefs, PlanningEnvironment environment) {
        int i;
        V5QueryResultDefinition qrdNode = this.getQrdReferencingThisQuery((V5Query)mainQuery);
        IDataType dataType = null;
        String queryItemName = (String)qItem.getPropertyValue("name");
        IDataType[] dataTypes = new IDataType[queryRefs.length];
        V5DataItem[] v5DataItems = new V5DataItem[queryRefs.length];
        boolean refQueriesAreAllRelational = true;
        int indexInSelectionList = -1;
        for (i = 0; i < queryRefs.length; ++i) {
            V5Query queryRef = (V5Query)queryRefs[i];
            if (!queryRef.isTabular() && !queryRef.isRelStyle()) {
                refQueriesAreAllRelational = false;
            }
            V5Selection selection = queryRef.getV5Selection();
            IXQEQueryNode[] dataItems = selection.getChildrenOfType(101003);
            if (i == 0) {
                for (int j = 0; j < dataItems.length && indexInSelectionList == -1; ++j) {
                    V5DataItem dataItem = (V5DataItem)dataItems[j];
                    if (!dataItem.getNameProperty().equals(queryItemName)) continue;
                    indexInSelectionList = j;
                    break;
                }
            }
            if (indexInSelectionList == -1 && (indexInSelectionList = qItem.getParent().getPositionOfChild(qItem)) >= dataItems.length) {
                indexInSelectionList = -1;
            }
            if (indexInSelectionList != -1) {
                V5DataItem dataItem;
                v5DataItems[i] = dataItem = (V5DataItem)dataItems[indexInSelectionList];
                dataTypes[i] = dataItem.getDataType();
                if (dataTypes[i] == null || dataTypes[i].getSubType() != DataSubType.METADATATYPE) continue;
                dataTypes[i] = DataTypeFactory.getVarcharType();
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidQueryOperation, queryItemName, (String)queryOperation.getPropertyValue("name"));
        }
        for (i = 0; i < queryRefs.length; ++i) {
            if (dataTypes[i] == null) continue;
            dataType = dataTypes[i];
            break;
        }
        if (dataType == null) {
            dataType = DataTypeFactory.getVarcharType();
        }
        for (i = 0; i < queryRefs.length; ++i) {
            IDataType lhs = dataType;
            IDataType rhs = dataTypes[i];
            if ((dataType = DataTypeComparator.getCompatibleType(lhs, rhs)) != null) continue;
            boolean relationalQuery = false;
            if (refQueriesAreAllRelational) {
                V5DataItem lda = v5DataItems[i];
                if (qrdNode != null && lda.isAggregate()) {
                    relationalQuery = true;
                }
            }
            if (relationalQuery) {
                dataType = dataTypes[0];
                break;
            }
            String datatypes = "";
            for (IDataType current : dataTypes) {
                datatypes = current != null ? datatypes + current.getTypeName() + " " : datatypes + "nullDataTypePtr ";
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleDataTypesInSetOperation, (Object)queryItemName, (Object)((String)queryOperation.getPropertyValue("name")), (Object)datatypes);
        }
        for (i = 0; i < queryRefs.length; ++i) {
            if (dataTypes[i] != null) continue;
            V5DataItem da = v5DataItems[i];
            da.setCastDataType(dataType);
        }
        qItem.setDataType(dataType);
        V5BoundDataItemReference exp = this.getDataItemExpression(queryOperation, queryItemName);
        if (exp != null) {
            exp.setDataType(dataType);
        }
    }

    private V5QueryResultDefinition getQrdReferencingThisQuery(V5Query mainQuery) {
        IXQEQueryNode[] qrds;
        if (mainQuery.getPropertyValue("referencedByRootQRD") == null) {
            return (V5QueryResultDefinition)mainQuery.getFirstChildByType(101055);
        }
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(mainQuery);
        String mainQueryName = mainQuery.getV5QueryName();
        for (IXQEQueryNode qrd : qrds = rootQuerySet.getChildrenOfType(101055)) {
            V5QueryResultDefinition v5Qrd = (V5QueryResultDefinition)qrd;
            if (!v5Qrd.getRefQueryProperty().equals(mainQueryName)) continue;
            return v5Qrd;
        }
        return null;
    }

    V5BoundDataItemReference getDataItemExpression(V5QueryOperation queryOperation, String name) {
        IXQEQueryNode[] dataItemsOp;
        String nameOperationQuery = (String)queryOperation.getPropertyValue("name");
        V5Query opParent = (V5Query)queryOperation.getAncestorOfType(101006);
        V5Selection opSelection = opParent.getV5Selection();
        for (IXQEQueryNode dataItem : dataItemsOp = opSelection.getChildrenOfType(101003)) {
            V5BoundDataItemReference nodeV5DIRef;
            String[] s;
            List<IXQEQueryNode> nodesV5DIRef = dataItem.getDescendantsOfTypeOrdered(201060, false);
            if (nodesV5DIRef.size() <= 0 || (s = (nodeV5DIRef = (V5BoundDataItemReference)nodesV5DIRef.get(0)).getNameParts()).length != 2 || !s[0].equals(nameOperationQuery) || !s[1].equals(name)) continue;
            return nodeV5DIRef;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QueryOperation queryOperation = (V5QueryOperation)node;
        if (this.isBound(queryOperation)) {
            this.traceQueryCondition(false, "The query operation is already bound.", trace);
            return false;
        }
        V5Query[] queryRefs = queryOperation.getReferencedV5Queries(environment);
        if (queryRefs.length == 0) {
            return false;
        }
        for (V5Query queryRef : queryRefs) {
            if (!this.hasNestedUnboundQuery(queryRef)) continue;
            this.traceQueryCondition(false, "One of the dependent queries is not bound yet.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The query items in this query need to be set.", trace);
        return true;
    }

    private boolean hasNestedUnboundQuery(V5Query query) {
        IXQEQueryNode[] dataItems;
        V5Source source = query.getV5Source();
        IXQEQueryNode v5QueryOperation = source.getFirstChildByType(101018);
        if (v5QueryOperation != null && !this.isBound(v5QueryOperation)) {
            return true;
        }
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode dataItem : dataItems = selection.getChildrenOfType(101003)) {
            V5DataItem di = (V5DataItem)dataItem;
            IXQEQueryNode exp = di.getExpr();
            if (exp == null || exp.getType() == 201023) continue;
            return di.getDataType() == null;
        }
        return false;
    }

    private boolean isBound(IXQEQueryNode query) {
        Object obj = query.getPropertyValue(PROP_BOUND_QUERY_ITEMS);
        return obj != null;
    }

    private void setBound(IXQEQueryNode query) {
        query.setPropertyValue(PROP_BOUND_QUERY_ITEMS, true);
    }
}

