/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqemoser.MoserMetadataConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public final class BindV5SqlQuery
extends Transformation {
    public static final String NATIVE = "native";
    public static final String PASSTHROUGH = "passThrough";

    public BindV5SqlQuery() {
        this.mName = "Bind V5 SQL query.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{101016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode topNode;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ParameterAccessCoordinator pac = ((RequestEnvironment)environment.getRequestEnvironment()).getParameterAccessCoordinator(environment);
        environment.getMetadataConnection();
        Governors governors = new Governors();
        governors.loadGovernors(pac);
        ((V5SqlQuery)node).setGovernors(governors);
        IXQEQueryNode[] children = node.getChildrenOfTypeOrdered(101041);
        ArrayList<String> nameList = new ArrayList<String>(children.length);
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode child = children[i];
            nameList.add((String)child.getPropertyValue("name"));
            child.extract();
        }
        IXQEQueryNode child = node.getChild(0);
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        if (child.getType() == 301019) {
            qBlock.setForeign(false);
        } else {
            qBlock.setForeign(true);
        }
        qBlock.setName(((V5SqlQuery)node).getName());
        String typeProp = "type";
        String sqlType = (String)node.getPropertyValue("type");
        if (sqlType == null || "".equals(sqlType)) {
            sqlType = NATIVE;
        }
        if (child.getType() == 301061 || PASSTHROUGH.equals(sqlType) || NATIVE.equals(sqlType)) {
            qBlock.setDerivedColumnList(nameList);
        }
        child.insertParent(qBlock);
        if (node.getParent() != null && node.getParent().getParent() != null && node.getParent().getParent().getParent() != null && (topNode = node.getParent().getParent().getParent()).getType() == 101002) {
            HashSet<String> fms;
            V5QuerySet querySet = (V5QuerySet)node.getParent().getParent().getParent();
            querySet.setExecutingSqlQuery();
            MetadataConnection mc = environment.getMetadataConnection();
            if (mc instanceof MoserMetadataConnection && (fms = (HashSet<String>)querySet.getPropertyValue("sqlQueryFM")) == null) {
                fms = new HashSet<String>();
                querySet.setPropertyValue("sqlQueryFM", fms);
                MoserMetadataConnection moserMC = (MoserMetadataConnection)mc;
                Map<String, Pair> pkgs = moserMC.getPackages();
                for (Pair p : pkgs.values()) {
                    String searchPath;
                    Map useSpec = (Map)p.getSecond();
                    String typeInUseSpec = "type";
                    String type = (String)useSpec.get("type");
                    if (type.equalsIgnoreCase("lwOlap") || (searchPath = (String)useSpec.get("searchPath")) == null) continue;
                    fms.add(this.appendSuffix(searchPath));
                }
            }
        }
    }

    private String appendSuffix(String searchPath) {
        String suffix = "/model";
        int i = searchPath.lastIndexOf(suffix);
        if (i == -1) {
            return searchPath + suffix;
        }
        return searchPath;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getChild(0).getType() != 301004) {
            status = true;
            this.traceQueryCondition(status, "The V5 SQL query has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "The V5 SQL query has been bound.", trace);
        }
        return status;
    }
}

