/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class CheckSecurityForModelBoundIdentifiers
extends Transformation {
    public CheckSecurityForModelBoundIdentifiers(int[] passNumbers) {
        this.mName = "Check security for model bound identifiers";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("v5QueryIdentifier");
        V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)node;
        IMetadata metadata = identifier.getMetadata();
        V5NameBinding nameBinding = new V5NameBinding(environment);
        nameBinding.checkModelSecurity(identifier.getIdentifier(), metadata);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean internalQuery;
        XQETrace trace = environment.getTrace();
        String transfNotRequired = "This bound identifier will not be checked for security.";
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null) {
            this.traceQueryCondition(false, "This bound identifier will not be checked for security.", trace);
            return false;
        }
        boolean bl = internalQuery = query.getPropertyValue("relationalSubquery") != null || ((RequestEnvironment)environment.getRequestEnvironment()).getInternalQuery();
        if (internalQuery && !query.isModelSecurityCheckRequired()) {
            this.traceQueryCondition(false, "This bound identifier will not be checked for security.", trace);
            return false;
        }
        if (node.getPropertyValue("v5QueryIdentifier") == null) {
            this.traceQueryCondition(false, "This bound identifier will not be checked for security.", trace);
            return false;
        }
        this.traceQueryCondition(true, "This bound identifier will be checked for security.", trace);
        return true;
    }
}

