/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;

public class CloneQueryUsedByMultipleQRDs
extends Transformation {
    private static final String REFERENCED_BY_XTAB_QRD = "refByXtabQrd";
    public static final String QUERY_NOT_CLONED = "notClonedDespiteBeingRefByMultipleQRDs";
    private static final String STR_TRUE = "true";

    public CloneQueryUsedByMultipleQRDs() {
        this.mName = "Clone query referenced by multiple QRDs.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101002};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query;
        V5QueryResultDefinition qrd;
        IXQEQueryNode[] qrds = node.getChildrenOfTypeOrdered(101055);
        boolean isGetParam = ((RequestEnvironment)environment.getRequestEnvironment()).isGetParametersRequest();
        HashSet<String> refQueryOfQRDWithMasterDetailLink = new HashSet<String>();
        if (isGetParam) {
            for (IXQEQueryNode current : qrds) {
                qrd = (V5QueryResultDefinition)current;
                query = qrd.getV5Query();
                if (!qrd.isList()) {
                    query.setBooleanPropertyValue(REFERENCED_BY_XTAB_QRD, STR_TRUE);
                }
                if (!qrd.isList() || qrd.getFirstChildByType(101059) == null) continue;
                refQueryOfQRDWithMasterDetailLink.add(qrd.getRefQueryProperty());
            }
        }
        for (IXQEQueryNode current : qrds) {
            qrd = (V5QueryResultDefinition)current;
            query = qrd.getV5Query();
            Object property = query.getPropertyValue("rootQRDName");
            if (property != null) {
                if (isGetParam) {
                    if (query.getBooleanPropertyValue(REFERENCED_BY_XTAB_QRD) != null || qrd.getFirstChildByType(101059) != null || refQueryOfQRDWithMasterDetailLink.contains(qrd.getRefQueryProperty())) {
                        qrd.cloneReferencedQuery(environment);
                        continue;
                    }
                    query.setPropertyValue(QUERY_NOT_CLONED, STR_TRUE);
                    environment.setTreeHasBeenModified();
                    continue;
                }
                qrd.cloneReferencedQuery(environment);
                continue;
            }
            query.setStringPropertyValue("rootQRDName", qrd.getName());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] qrds = node.getChildrenOfTypeOrdered(101055);
        if (qrds.length == 0) {
            this.traceQueryCondition(true, "No QRDs where found.", environment.getTrace());
            return false;
        }
        this.traceQueryCondition(true, "Always applied.", environment.getTrace());
        return true;
    }
}

