/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.v5.V5SyntaxException;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.CreateUniqueValidSqlIdentifierForSqlRangeVar;
import com.cognos.xqe.transformation.v5tocogsql.util.QuerySubjectSQLGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.List;

public class ConvertSqlTextToAST
extends Transformation {
    private static final String PROP_SQL_TEXT = "sqlText";
    private static final String PROP_SQL_TYPE = "type";
    private static final String PROP_SQL_TYPE_PASSTHROUGH = "passThrough";
    private static final String PROP_SQL_TYPE_NATIVE = "native";
    private static final String PROP_NAME = "name";

    public ConvertSqlTextToAST() {
        this.mName = "Convert SQL Text to AST";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Object prop = node.getPropertyValue(PROP_SQL_TEXT);
        if (prop instanceof String) {
            String sqlType;
            node.removeProperty(PROP_SQL_TEXT);
            String exp = (String)prop;
            if (exp.contains("#")) {
                MacroExpander expander = new MacroExpander();
                exp = expander.expandSQL(node, environment, exp);
            }
            String datasource = (String)node.getPropertyValue("dataSource");
            V5Source source = (V5Source)node.getParent();
            if (source == null) {
                this.addDataSourceToRequestEnv(node, environment);
            }
            if (null == (sqlType = (String)node.getPropertyValue(PROP_SQL_TYPE)) || "".equals(sqlType) || PROP_SQL_TYPE_PASSTHROUGH.equals(sqlType) || PROP_SQL_TYPE_NATIVE.equals(sqlType)) {
                XQENodeFactory nodeFactory = environment.getNodeFactory();
                SQLNativeSql sqlNative = (SQLNativeSql)nodeFactory.createNode(301012);
                sqlNative.setSqlString(exp);
                if (PROP_SQL_TYPE_PASSTHROUGH.equals(sqlType)) {
                    sqlNative.setIsPassThrough(true);
                }
                node.addChild(sqlNative);
                return;
            }
            if (source == null && (datasource == null || datasource.equals(""))) {
                this.setDataSourceProperty(node, environment);
            }
            SQLProcessor parser = new SQLProcessor(environment.getNodeFactory());
            try {
                IXQEQueryNode[] sqlColumnNodes;
                IXQEQueryNode aNode = parser.parseQuery(exp);
                SQLValueList sqlValueList = null;
                if (aNode.getType() == 301010 || aNode.getType() == 301015) {
                    sqlValueList = (SQLValueList)aNode.getFirstChildByType(301030);
                } else {
                    IXQEQueryNode temp = aNode;
                    while (temp.getNumberChildren() != 0) {
                        IXQEQueryNode child = temp.getChild(0);
                        if (child.getType() == 301010 || child.getType() == 301015) {
                            sqlValueList = (SQLValueList)child.getFirstChildByType(301030);
                            break;
                        }
                        temp = temp.getChild(0);
                    }
                }
                if (sqlValueList != null && (sqlColumnNodes = sqlValueList.getChildrenOfType(301005)).length > 0) {
                    for (int i = 0; i < sqlColumnNodes.length; ++i) {
                        String comparedName = ((SQLColumn)sqlColumnNodes[i]).getName();
                        for (int j = i + 1; j < sqlColumnNodes.length; ++j) {
                            String colName = ((SQLColumn)sqlColumnNodes[j]).getName();
                            if (!colName.equals(comparedName)) continue;
                            throw new XQERuntimeException(XQEMessageKeys.V5_InvalidColumnName, colName);
                        }
                    }
                }
                if (aNode != null) {
                    MetadataConnection metadataConnection = environment.getMetadataConnection();
                    List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
                    List<IXQEQueryNode> children = aNode.getDescendantsOfTypesOrdered(new int[]{301061, 301016}, false);
                    for (IXQEQueryNode child : children) {
                        IDataSource dataSource;
                        IModelDataSource ds;
                        SQLIdentifier identifier = (SQLIdentifier)child;
                        QuerySubjectSQLGenerator.replaceDSRefs(dataSources, identifier, environment);
                        QuerySubjectSQLGenerator.expandMacrosinSQLIdentifier(identifier, environment);
                        if (child.getType() != 301016) continue;
                        String baseName = identifier.getName();
                        String getModelDatasourceName = identifier.getModelDatasourceName();
                        if ((getModelDatasourceName == null || getModelDatasourceName.isEmpty()) && baseName != null && !baseName.isEmpty() && (ds = RQPUtilities.getModelDataSource(dataSources, baseName)) != null) {
                            identifier.setModelDatasourceName(ds.getName());
                        }
                        if ((dataSource = CreateUniqueValidSqlIdentifierForSqlRangeVar.getDataSource(child, environment)) == null || !dataSource.isRelational()) continue;
                        environment.addDataSource(dataSource);
                    }
                    node.addChild(aNode);
                    return;
                }
            }
            catch (ParseException e) {
                throw new V5SyntaxException(e);
            }
        }
    }

    private void setDataSourceProperty(IXQEQueryNode node, PlanningEnvironment environment) {
        MetricsService.startCollectingMetric((RequestEnvironment)environment.getRequestEnvironment(), "mfwRequest");
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        MetricsService.endCollectingMetric((RequestEnvironment)environment.getRequestEnvironment(), "mfwRequest");
        List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
        if (dataSources != null && !dataSources.isEmpty()) {
            ArrayList<String> dataSourceNames = new ArrayList<String>();
            for (IModelDataSource ds : dataSources) {
                dataSourceNames.add(ds.getCMDataSourceName());
            }
            node.removeProperty("dataSource");
            node.setPropertyValue("dataSource", dataSourceNames.get(0));
        }
    }

    private void addDataSourceToRequestEnv(IXQEQueryNode node, PlanningEnvironment environment) {
        MetricsService.startCollectingMetric((RequestEnvironment)environment.getRequestEnvironment(), "mfwRequest");
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        MetricsService.endCollectingMetric((RequestEnvironment)environment.getRequestEnvironment(), "mfwRequest");
        List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
        if (dataSources != null) {
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource cubeDataSource = dataSources.get(i);
                execEnv.getOrAddDataSource(cubeDataSource);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object prop = node.getPropertyValue(PROP_SQL_TEXT);
        return prop instanceof String;
    }
}

