/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberParameter;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public class ConvertV5MemberParameterToV5Parameter
extends Transformation {
    public ConvertV5MemberParameterToV5Parameter() {
        this.mName = "Convert V5 Member Parameter to V5Parameter.";
        this.mPassNumbers = new int[]{30};
        this.mTypes = new int[]{201027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MemberParameter v5MemberParameter = (V5MemberParameter)node;
        String parameterName = v5MemberParameter.getPrompt();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5Parameter memberPromptNode = (V5Parameter)nodeFactory.createNode(201024);
        memberPromptNode.setValue(parameterName);
        memberPromptNode.setIsMemberParameter(true);
        IXQEQueryNode child = v5MemberParameter.getChild(0);
        while (child.getType() == 201060) {
            if ((child = ((V5BoundDataItemReference)child).getReferencedExpression()).isOfCategory(201120)) continue;
            child = child.getChild(0);
        }
        V5BoundModelIdentifier modelIdentifier = null;
        IMetadata metaData = null;
        if (child.getType() == 201116) {
            modelIdentifier = (V5BoundModelIdentifier)child;
            metaData = modelIdentifier.getMetadata();
        }
        if (metaData == null || metaData.getObjectType() != MetadataType.HIERARCHY && metaData.getObjectType() != MetadataType.LEVEL) {
            String childExpression = ((V5SimpleNode)v5MemberParameter.getChild(0)).getNativeName();
            V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
            if (dataItem == null) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidModelInParameter2, childExpression);
            }
            String dataItemName = dataItem.getNameProperty();
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidModelInParameter1, childExpression, dataItemName);
        }
        memberPromptNode.setMetadata(metaData);
        memberPromptNode.setDataType(metaData.getDataType());
        memberPromptNode.setModelIdentifier(modelIdentifier.getIdentifier());
        node.exchange(memberPromptNode, false);
    }
}

