/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CreateSubquery
extends Transformation {
    public CreateSubquery() {
        this.mName = "Create subqueries referenced by other queries, joins, and set operations.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101006};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        V5QuerySet qSet = (V5QuerySet)query.getAncestorOfType(101002);
        String qrdName = (String)query.getPropertyValue("rootQRDName");
        V5QueryResultDefinition qrd = qSet.getQRD(qrdName);
        String origQueryName = qrd.getV5Query().getV5QueryName();
        qrd.cloneReferencedQuery(environment);
        qrd.setOriginalRefQueryProperty(origQueryName);
        query.removeProperty("rootQRDName");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        boolean ret = query.getPropertyValue("rootQRDName") != null;
        String msg = "Query is not used in a root QRD and as sub query";
        if (ret) {
            V5QuerySet qSet = (V5QuerySet)query.getAncestorOfType(101002);
            boolean bl = ret = !qSet.getReferencingQueries(query.getV5QueryName(), environment).isEmpty();
            if (ret) {
                msg = "Query is used in a root QRD and as sub query";
            }
        }
        this.traceQueryCondition(ret, msg, environment.getTrace());
        return ret;
    }
}

