/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;

public class ExpandModelCalculations
extends Transformation {
    public static final String CALC_FORMAT = "calculationFormat";
    public static final String PROP_MAP_CALCULATION_TO_DATAITEM = "calculationToDataItems";
    public static final String PROP_BOOL_COPY_ONLY_CALCULATION_EXPRESSION = "copyOnlyCalculationExpression";
    public static final String PROP_BOOL_MODEL_CALC_REF = "modelCalculationRef";

    public ExpandModelCalculations(int[] passNumbers) {
        this.mName = "Expand standalone model calculations";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201116};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IXQEQueryNode parent = v5BoundID.getParent();
        boolean inFilterExpr = false;
        boolean inTrivialExpr = false;
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(environment, v5BoundID);
        V5Selection selection = (V5Selection)v5BoundID.getAncestorOfType(101009);
        if (selection == null) {
            inFilterExpr = true;
            selection = ((V5Query)v5BoundID.getAncestorOfType(101006)).getV5Selection();
        } else if (parent != null) {
            IXQEQueryNode gParent;
            if (parent.getType() == 101004) {
                inTrivialExpr = true;
                parent = parent.getParent();
            } else if (parent.getType() == 101003 && (gParent = parent.getParent()) != null && gParent.getType() == 101009) {
                inTrivialExpr = true;
            }
        }
        IMetadata md = this.getModelCalculation(v5BoundID);
        V5DataItem ancestorV5DataItem = (V5DataItem)v5BoundID.getAncestorOfType(101003);
        if (md != null && ancestorV5DataItem != null && md.getID() != null) {
            ancestorV5DataItem.setModelCalculationID(md.getID());
        }
        boolean copyOnlyCalculationExpr = inFilterExpr || inTrivialExpr;
        V5DataItem v5DataItem = this.getDataItemThatContainsCalculationExpr(environment, v5BoundID, querySet);
        if (v5DataItem == null) {
            MetadataConnection mdConn;
            IXQEQueryNode itemExpr = this.getExpressionNode(environment, v5BoundID);
            if (itemExpr == null && (mdConn = environment.getMetadataConnection()) instanceof MoserMetadataConnection) {
                ((MoserMetadataConnection)mdConn).throwCalculationNoExpr(v5BoundID.getMetadata());
            }
            DMRUtilities.isDMRExpressionHasSummaryFunction(environment, v5BoundID, itemExpr);
            String format = ((ICalculation)md).getFormat();
            if (format != null) {
                itemExpr.setPropertyValue(CALC_FORMAT, format);
            }
            v5DataItem = this.createV5DataItem(environment, itemExpr, v5BoundID, selection);
            this.setV5DataItemPropertiesFromCalculation(v5DataItem, v5BoundID, null, false);
            if (md instanceof MoserCalculation) {
                v5DataItem.setPropertyValue("contextMetadata", md);
                v5DataItem.setModuleCalculation(true);
                if (((MoserCalculation)md).isRelativeTime()) {
                    v5DataItem.setPropertyValue("RTCalc", Boolean.TRUE);
                }
            }
            node.exchange(v5DataItem);
            HashMap calculationToV5DataItems = querySet.getPropertyValue(PROP_MAP_CALCULATION_TO_DATAITEM);
            if (calculationToV5DataItems == null) {
                calculationToV5DataItems = new HashMap();
                querySet.setPropertyValue(PROP_MAP_CALCULATION_TO_DATAITEM, calculationToV5DataItems);
            }
            ((HashMap)calculationToV5DataItems).put(this.getModelCalculation(v5BoundID), v5DataItem);
            if (copyOnlyCalculationExpr) {
                v5DataItem.setPropertyValue(PROP_BOOL_COPY_ONLY_CALCULATION_EXPRESSION, true);
            }
        } else {
            V5BoundDataItemReference dataItemReference = (V5BoundDataItemReference)environment.getNodeFactory().createNode(201060);
            dataItemReference.setIdentifier('[' + v5DataItem.getNameProperty() + ']');
            dataItemReference.setRefDataItem(v5DataItem);
            dataItemReference.setPropertyValue(PROP_BOOL_MODEL_CALC_REF, true);
            node.exchange(dataItemReference);
            if (copyOnlyCalculationExpr) {
                dataItemReference.setPropertyValue(PROP_BOOL_COPY_ONLY_CALCULATION_EXPRESSION, true);
            }
        }
        if (inTrivialExpr) {
            this.setV5DataItemPropertiesFromCalculation((V5DataItem)parent, v5BoundID, ((V5DataItem)parent).getAggregateProperty(), true);
        }
    }

    private IXQEQueryNode getExpressionNode(PlanningEnvironment env, V5BoundModelIdentifier v5BoundID) {
        if (!((RequestEnvironment)env.getRequestEnvironment()).isValidateRequest()) {
            return v5BoundID.getV5ValueExpression(env);
        }
        IMetadata md = this.getModelCalculation(v5BoundID);
        if (!(md instanceof MoserCalculation)) {
            return v5BoundID.getV5ValueExpression(env);
        }
        MoserCalculation calc = (MoserCalculation)md;
        XQERuntimeException e = MoserModuleUtil.preCheckCalculatedQueryItem(calc, calc.getExpression());
        if (e == null) {
            return v5BoundID.getV5ValueExpression(env);
        }
        if ("validateAll".equals(((RequestEnvironment)env.getRequestEnvironment()).getOperationName())) {
            IXQEQueryNode dataItem = v5BoundID.getAncestorOfType(101003);
            if (dataItem != null) {
                String moduleLocation = (String)dataItem.getPropertyValue("moduleLocation");
                while (moduleLocation == null && (dataItem = dataItem.getAncestorOfType(101003)) != null) {
                    moduleLocation = (String)dataItem.getPropertyValue("moduleLocation");
                }
                if (moduleLocation == null) {
                    dataItem = null;
                }
            }
            ((RequestEnvironment)env.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, e), dataItem, env.getRoot());
            return env.getNodeFactory().createNode(201023);
        }
        throw e;
    }

    public V5DataItem getDataItemThatContainsCalculationExpr(PlanningEnvironment environment, V5BoundModelIdentifier v5BoundID, V5QuerySet querySet) {
        HashMap calculationToV5DataItems = (HashMap)querySet.getPropertyValue(PROP_MAP_CALCULATION_TO_DATAITEM);
        if (calculationToV5DataItems != null) {
            return (V5DataItem)calculationToV5DataItems.get(this.getModelCalculation(v5BoundID));
        }
        return null;
    }

    private V5DataItem createV5DataItem(PlanningEnvironment environment, IXQEQueryNode dataItemExpr, V5BoundModelIdentifier boundID, V5Selection v5Selection) {
        V5DataItem v5DataItem = (V5DataItem)environment.getNodeFactory().createNode(101003);
        v5DataItem.setNameProperty(this.getModelCalculation(boundID).getCaption());
        v5DataItem.addChild(dataItemExpr);
        v5DataItem.setPropertyValue("fromModelCalculation", this.getModelCalculation(boundID).getV5UniqueName());
        return v5DataItem;
    }

    private void setV5DataItemPropertiesFromCalculation(V5DataItem v5DataItem, V5BoundModelIdentifier calcID, String origAggregateProperty, boolean useOriginalName) {
        String currency;
        String calcFormat;
        String usage;
        ICalculation calcMetadata;
        String calcRegularAggregate;
        if (origAggregateProperty == null) {
            origAggregateProperty = "automatic";
        }
        if (origAggregateProperty.equals("automatic") || origAggregateProperty.equals("calculated")) {
            v5DataItem.setPropertyValue("originalAggregate", origAggregateProperty);
        }
        if ("sum".equals(calcRegularAggregate = (calcMetadata = (ICalculation)this.getModelCalculation(calcID)).getRegularAggregate())) {
            calcRegularAggregate = "total";
        }
        if (!V5AggregateEnum.isDefinedAggregateFunction(origAggregateProperty) && V5AggregateEnum.isDefinedRegularAggregate(calcRegularAggregate)) {
            v5DataItem.setAggregateProperty(calcRegularAggregate);
        }
        if ("calculated".equals(origAggregateProperty) || "automatic".equals(origAggregateProperty) && "calculated".equals(calcRegularAggregate)) {
            v5DataItem.setAggregateProperty(this.convertRegularAggregate(calcMetadata.getRegularAggregate()));
        }
        if ((usage = calcMetadata.getUsage()) != null) {
            v5DataItem.setPropertyValue("usage", usage);
        }
        if ((calcFormat = calcMetadata.getFormat()) != null && v5DataItem.getPropertyValue("customFormat") == null) {
            v5DataItem.setPropertyValue("customFormat", calcFormat);
        }
        if (v5DataItem.getPropertyValue("label") == null) {
            if (!useOriginalName) {
                v5DataItem.setPropertyValue("label", calcMetadata.getCaption());
            } else if (calcID.getMetadata() instanceof MoserBaseMetadata) {
                v5DataItem.setPropertyValue("label", ((MoserBaseMetadata)((Object)calcID.getMetadata())).getLabel());
            } else {
                v5DataItem.setPropertyValue("label", calcID.getMetadata().getCaption());
            }
            v5DataItem.setPropertyValue("isLabelFromModel", Boolean.TRUE);
        }
        if ((currency = calcMetadata.getCurrency()) != null) {
            v5DataItem.setPropertyValue("currency", currency);
        }
        v5DataItem.setPropertyValue("refModelObjectName", calcMetadata.getCaption());
    }

    private String convertRegularAggregate(String modelAggr) {
        if (modelAggr.equals("unknown") || modelAggr.equals("unsupported")) {
            return "automatic";
        }
        if (modelAggr.equals("sum")) {
            return "total";
        }
        return modelAggr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getAncestorOfType(101006) == null) {
            this.traceNodeCondition(false, "Expression not in the context of a V5Query.", xqeTrace);
            return false;
        }
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (this.getModelCalculation(v5BoundID) != null) {
            this.traceNodeCondition(true, "The standalone calculation will be replaced by its expression.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The V5BoundMultiPartIdentifier is not a calculation.", xqeTrace);
        return false;
    }

    private IMetadata getModelCalculation(V5BoundModelIdentifier id) {
        IMetadata metaData = id.getMetadata();
        if (metaData == null) {
            return null;
        }
        while (MetadataType.SHORTCUT == metaData.getObjectType()) {
            metaData = ((IShortcut)metaData).getTarget();
        }
        if (metaData instanceof ICalculation && !((ICalculation)metaData).getCalcType().equals("namedSet")) {
            return metaData;
        }
        return null;
    }
}

