/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqemoser.time.MoserTimePeriod;
import com.cognos.xqemoser.time.MoserTimeUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ExpandMoserTimePeriod
extends Transformation {
    public ExpandMoserTimePeriod() {
        this.mName = "Expand moser time period.";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IXQEQueryNode newExpr = MoserTimeUtil.createFilter(environment, (MoserTimePeriod)v5BoundID.getMetadata());
        node.exchange(newExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (v5BoundID.getMetadata() instanceof MoserTimePeriod) {
            this.traceNodeCondition(true, "Moser time period will be replaced by its expression.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Not a Moser time period.", xqeTrace);
        return false;
    }
}

