/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import java.util.List;

public class ExpandQueryItemOfQuerySubject
extends Transformation {
    private static final String PREFIX = "</?refobj>|</?expression>";

    public ExpandQueryItemOfQuerySubject() {
        this.mName = "Expand query item of query subject";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IXQEQueryNode exprNode = v5BoundID.getV5ValueExpression(environment);
        DMRUtilities.isDMRExpressionHasSummaryFunction(environment, v5BoundID, exprNode);
        if (exprNode.getType() == 201030) {
            ((V5MultiPartIdentifier)exprNode).setCreatedFromQueryItemOfQuerySubject();
        }
        node.exchange(exprNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null) {
            this.traceNodeCondition(false, "The query item is not in a v5 query.", xqeTrace);
            return false;
        }
        List<IModelDataSource> dataSources = query.getMetadataConnectionMetadataPath(environment).getModelDataSources();
        ICube cube = null;
        if (dataSources.size() > 0) {
            cube = dataSources.get(0).getCube();
        }
        if (cube == null || cube.getModelDataSource().isRelational()) {
            this.traceNodeCondition(false, "The query is not against OLAP data source.", xqeTrace);
            return false;
        }
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IMetadata metadata = v5BoundID.getMetadata();
        if (metadata == null || metadata.getObjectType() != MetadataType.QUERY_ITEM || !(metadata instanceof IQueryItemOfQuerySubject)) {
            this.traceNodeCondition(false, "The not is not a query item of query subject.", xqeTrace);
            return false;
        }
        if (!((IQueryItemOfQuerySubject)metadata).getQuerySubject().getFilters().isEmpty()) {
            this.traceNodeCondition(false, "The query item belongs to a query subject that contains model filters.", xqeTrace);
            return false;
        }
        String expr = ((IQueryItemOfQuerySubject)metadata).getExpression();
        if (expr == null || expr.replaceAll(PREFIX, "").trim().length() == 0) {
            this.traceNodeCondition(false, "Query item of query subject does not have an valid expression.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Query item of query subject needs to be expanded.", xqeTrace);
        return true;
    }
}

