/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;

public class ExpandRolapNamedSetMultiPartIdentifier
extends Transformation {
    public ExpandRolapNamedSetMultiPartIdentifier() {
        this.mName = "Expand NamedSet to a list of members.";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        String namedSetExp = ((INamedSet)metaData).getExpression();
        if (namedSetExp != null) {
            namedSetExp = MetadataUtil.extractExpressionFromModelString(namedSetExp, environment);
        }
        IXQEQueryNode enode = RQPUtilities.createV5ValueExpression(namedSetExp, environment, null);
        enode.setPropertyValue("rolapNamedSetExpression", Boolean.TRUE);
        node.exchange(enode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String calcType;
        XQETrace trace = environment.getTrace();
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        if (metaData == null) {
            this.traceNodeCondition(false, "Unable to replace Rolap bound object which is null.", trace);
            return false;
        }
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        String s1 = "a Rolap cube namedSet.";
        if (metaData.getObjectType() == MetadataType.CALCULATION && (calcType = ((ICalculation)metaData).getCalcType()).equals("namedSet")) {
            ICube cube = null;
            INamedSet namedSet = (INamedSet)metaData;
            cube = namedSet.getDimension() == null ? namedSet.getConnection().getCubes()[0] : namedSet.getDimension().getCube();
            if (cube.getModelDataSource().isROLAP()) {
                IXQEQueryNode parent;
                ExecutionEnvironment execEnv;
                LoopDetectionChain loopDetectionChain;
                String namedSetExp = ((INamedSet)metaData).getExpression();
                if (namedSetExp != null && !(loopDetectionChain = (execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()).getMetadataLoopDetection()).push(metaData.getV5UniqueName()) && (parent = node.getParent()) != null && parent.getPropertyValue("rolapNamedSetExpression") != null && parent.getAncestorOfType(101009).getNumberChildrenOfType(101003) == 1) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", loopDetectionChain.serialize());
                }
                status = true;
            }
        }
        if (!status) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append(s1);
        } else {
            msgStr.append(" ");
            msgStr.append(s1);
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }
}

