/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ExtractCrossJoinIntoProduct
extends RQETransformation {
    public ExtractCrossJoinIntoProduct(int passNumber) {
        this.mName = "ExtractCrossJoinIntoProduct.";
        this.mPassNumbers = new int[]{passNumber};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (node.getParent().getType() == 301011) {
            IXQEQueryNode product = nodeFactory.createNode(301014);
            node.getParent().exchange(product, true);
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLJoin joinNode = (SQLJoin)node;
        boolean parentIsCrossProduct = false;
        if (node.getParent().getType() == 301011 && ((SQLJoin)node.getParent()).getJoinType() == SQLJoin.SubType.CROSS) {
            parentIsCrossProduct = true;
        }
        boolean bl = status = joinNode.getJoinType() == SQLJoin.SubType.CROSS && (node.getParent().getType() == 301014 || parentIsCrossProduct);
        if (status) {
            this.traceQueryCondition(status, "ExtractCrossJoinIntoProduct will be applied.", trace);
        } else {
            this.traceQueryCondition(status, "ExtractCrossJoinIntoProduct is not applied", trace);
        }
        return status;
    }
}

