/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class IdentifyQueriesAndItemsReferencedByQRD
extends Transformation {
    public IdentifyQueriesAndItemsReferencedByQRD() {
        this.mName = "Identify Queries and Items Referenced By QRD.";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String refDataItemName;
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        V5Query query = qrd.getV5Query();
        query.setIsReferenced();
        for (IXQEQueryNode valueSetNode : qrd.getDescendantsOfType(101057, false)) {
            V5ValueSet valueSet = (V5ValueSet)valueSetNode;
            refDataItemName = valueSet.getRefDataItemProperty();
            if (refDataItemName == null) continue;
            IdentifyQueriesAndItemsReferencedByQRD.setDataItemAsReferenced(query, refDataItemName);
        }
        for (IXQEQueryNode dataItemRefNode : qrd.getDescendantsOfType(101015, false)) {
            V5DataItemRef dataItemRef = (V5DataItemRef)dataItemRefNode;
            refDataItemName = dataItemRef.getDataItemRefProperty();
            IdentifyQueriesAndItemsReferencedByQRD.setDataItemAsReferenced(query, refDataItemName);
        }
        for (IXQEQueryNode sortItemNode : qrd.getDescendantsOfType(101056, false)) {
            V5SortItem sortItem = (V5SortItem)sortItemNode;
            refDataItemName = sortItem.getRefDataItem();
            IdentifyQueriesAndItemsReferencedByQRD.setDataItemAsReferenced(query, refDataItemName);
        }
        qrd.setReferencesWalked();
    }

    public static void tagQueryAsReferenced(V5Query query) {
        for (IXQEQueryNode detailFilter : query.getV5DetailFilters()) {
            IdentifyQueriesAndItemsReferencedByQRD.tagDataItemReferences(detailFilter);
        }
        for (IXQEQueryNode summaryFilter : query.getV5SummaryFilters()) {
            IdentifyQueriesAndItemsReferencedByQRD.tagDataItemReferences(summaryFilter);
            for (IXQEQueryNode summFilterLevelNode : summaryFilter.getDescendantsOfType(101012, false)) {
                V5SummaryFilterLevel summFilterLevel = (V5SummaryFilterLevel)summFilterLevelNode;
                String refDataItemName = summFilterLevel.getRefDataItem();
                IdentifyQueriesAndItemsReferencedByQRD.setDataItemAsReferenced(query, refDataItemName);
            }
        }
        for (IXQEQueryNode slicer : query.getV5Slicers()) {
            IdentifyQueriesAndItemsReferencedByQRD.tagDataItemReferences(slicer);
        }
        query.setIsReferenced();
    }

    private static void setDataItemAsReferenced(V5Query query, String refDataItemName) {
        V5DataItem v5DItem = query.getV5Selection().getDataItemByRefName(refDataItemName);
        String qName = (String)query.getPropertyValue("name");
        if (v5DItem == null) {
            throw new XQERuntimeException(XQEMessageKeys.V5_RefItemNotFound, refDataItemName, qName);
        }
        v5DItem.setIsReferenced();
    }

    public static void tagDataItemReferences(IXQEQueryNode node) {
        for (IXQEQueryNode childNode : node.getDescendantsOfTypeOrdered(201060, false)) {
            V5BoundDataItemReference dataItemReference = (V5BoundDataItemReference)childNode;
            IdentifyQueriesAndItemsReferencedByQRD.tagDataItemReference(dataItemReference);
        }
    }

    public static void tagDataItemReference(V5BoundDataItemReference dataItemReference) {
        V5Query referencedQuery;
        V5DataItem referencedDataItem = dataItemReference.getRefDataItem();
        referencedDataItem.setIsReferenced();
        if (dataItemReference.isQueryRefItem() && (referencedQuery = (V5Query)referencedDataItem.getAncestorOfType(101006)).getV5QueryName().equals(dataItemReference.getNameParts()[0])) {
            IdentifyQueriesAndItemsReferencedByQRD.tagQueryAsReferenced(referencedQuery);
            for (IXQEQueryNode dataItemNode : referencedQuery.getV5Selection().getChildren()) {
                ((V5DataItem)dataItemNode).setIsReferenced();
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        if (qrd.referencesWalked()) {
            this.traceNodeCondition(false, "This references for the QRD have already been walked.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This references for the QRD have not been walked.", trace);
        return true;
    }
}

