/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5CubeCalculatedDefaultMember;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.unwinding.ExpandChildrenROLAPCalculatedMember;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class InsertCubeCalculatedDefaultMembers
extends Transformation {
    public InsertCubeCalculatedDefaultMembers() {
        this.mName = "Insert cube's default members which are calculated members and create V5CubeCalculatedDefaultMember nodes.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List maskList = (List)((V5Query)node).getPropertyValue("calculatedDefaultMembersMaskList");
        XQENodeFactory nf = environment.getNodeFactory();
        List<IMember> memberList = this.getModelCalculatedDefaultMembers(node, environment);
        for (IMember m : memberList) {
            String v5Mun = m.getV5MUN();
            String name = m.getName();
            IXQEQueryNode v5Expression = null;
            v5Expression = this.createMaskV5MemberFunction(v5Mun, name, environment, m.getHierarchy());
            if (maskList != null && (maskList.size() == 0 || maskList.indexOf(m.getHierarchy()) != -1)) {
                v5Expression = this.createMaskV5MemberFunction(v5Mun, name, environment, m.getHierarchy());
            } else {
                v5Expression = nf.createNode(101004);
                ((V5Expression)v5Expression).setExpression(v5Mun);
            }
            V5CubeCalculatedDefaultMember v5CalculatedDefaultMember = (V5CubeCalculatedDefaultMember)nf.createNode(101077);
            v5CalculatedDefaultMember.addChild(nf.deepCopyNode(v5Expression));
            node.addChild(v5CalculatedDefaultMember);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IMember> memberList;
        XQETrace xqeTrace = environment.getTrace();
        if (ExpandChildrenROLAPCalculatedMember.isMetadataQuery(environment)) {
            this.traceNodeCondition(false, "Do not apply the transformation for metadata queries", xqeTrace);
            return false;
        }
        if (node.getFirstChildByType(101077) != null) {
            this.traceNodeCondition(false, "Necessary V5CubeCalculatedDefaultMember nodes have already been added to the query.", xqeTrace);
            return false;
        }
        if (((V5Query)node).getV5Source().getChildrenOfTypes(new int[]{101018, 101019, 101016}).length > 0) {
            this.traceNodeCondition(false, "The query is a relational style query.", xqeTrace);
            return false;
        }
        if (this.isValidProvider(environment, (V5Query)node) && (memberList = this.getModelCalculatedDefaultMembers(node, environment)).size() > 0) {
            this.traceNodeCondition(true, "Need to add any V5CubeCalculatedDefaultMember node as there is calculated default member.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "No need to add any V5CubeCalculatedDefaultMember node as there is no calculated default member.", xqeTrace);
        return false;
    }

    private boolean isValidProvider(PlanningEnvironment environment, V5Query query) {
        List<IModelDataSource> ds = query.getMetadataConnectionMetadataPath(environment).getModelDataSources();
        for (IModelDataSource datasource : ds) {
            if (!datasource.isROLAP()) continue;
            return true;
        }
        return false;
    }

    private List<IMember> getModelCalculatedDefaultMembers(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<IMember> memberList = new ArrayList<IMember>();
        ICube cube = null;
        List<IModelDataSource> mdsList = environment.getMetadataConnection().getModelDataSources();
        if (mdsList.size() == 1) {
            IModelDataSource mds = mdsList.get(0);
            cube = mds.getCube();
        } else if (mdsList.size() > 1) {
            IXQEQueryNode[] dItems = ((V5Query)node).getV5Selection().getChildrenOfType(101003);
            boolean bCubeFound = false;
            for (IXQEQueryNode di : dItems) {
                IXQEQueryNode v5Expr = ((V5DataItem)di).getDetailExpression();
                if (101004 == v5Expr.getType()) {
                    String refDSName = null;
                    String expr = ((V5Expression)v5Expr).getExpression();
                    if (null != expr) {
                        refDSName = this.getRefDSNameInExpr(expr);
                    } else {
                        IXQEQueryNode[] v5BMIs = v5Expr.getDescendantsOfType(201116, false);
                        if (v5BMIs.length != 0) {
                            V5BoundModelIdentifier v5BMI = (V5BoundModelIdentifier)v5BMIs[0];
                            String[] nameparts = v5BMI.getNameParts();
                            refDSName = nameparts[0];
                        }
                    }
                    for (IModelDataSource mds : mdsList) {
                        String cmDatasource = mds.getCMDataSourceName();
                        if (null == refDSName || !refDSName.equals(cmDatasource)) continue;
                        cube = mds.getCube();
                        bCubeFound = true;
                        break;
                    }
                }
                if (bCubeFound) break;
            }
        }
        if (cube != null) {
            List<IDimension> dimList = cube.getDimensions();
            for (IDimension d : dimList) {
                List<IHierarchy> hierList = d.getHierarchies();
                block3: for (IHierarchy h : hierList) {
                    IMember m = h.getDefaultMember();
                    if (m == null || m.getHierarchy() == null) continue;
                    if (m instanceof IMeasure) {
                        String modelExpression;
                        if (((IMeasure)m).getRegularAggregate() != AggregateTypeEnum.CALCULATED || (modelExpression = ((IMeasure)m).getExpression()) == null || modelExpression.length() == 0) continue;
                        memberList.add(m);
                        continue;
                    }
                    IHierarchy hierarchy = m.getHierarchy();
                    if (hierarchy.getDimension().getType() == DimensionTypeEnum.INTERNAL) continue;
                    List<IMember> calcMembers = hierarchy.getCalculatedMembers();
                    for (IMember calcMemb : calcMembers) {
                        if (!calcMemb.getUniqueName().equals(m.getUniqueName())) continue;
                        memberList.add(m);
                        continue block3;
                    }
                }
            }
        }
        return memberList;
    }

    private String getRefDSNameInExpr(String expr) {
        int closeBracketIdx;
        String refDSName = null;
        int openBracketIdx = expr.indexOf(91);
        if (-1 != openBracketIdx && -1 != (closeBracketIdx = expr.indexOf(93)) && !expr.contains("#")) {
            refDSName = expr.substring(openBracketIdx + 1, closeBracketIdx);
        }
        return refDSName;
    }

    protected V5MemberFunction createMaskV5MemberFunction(String v5MUN, String name, PlanningEnvironment environment, IHierarchy hierarchy) {
        IXQEQueryNode node = RQPUtilities.createV5ValueExpression("1", environment, null);
        V5MemberFunction memberFunction = V5ToCogMDXUtilities.createV5MemberExpression(node, environment, v5MUN, name, null);
        XQENodeFactory factory = environment.getNodeFactory();
        V5BoundModelIdentifier hierarchyNode = (V5BoundModelIdentifier)factory.createNode(201116);
        hierarchyNode.setMetadata(hierarchy);
        hierarchyNode.setIdentifier(hierarchy.getV5UniqueName());
        memberFunction.addChild(hierarchyNode);
        memberFunction.setPropertyValue("createdFromROLAPCalcMember", Boolean.TRUE);
        return memberFunction;
    }
}

