/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundValueUniqueName;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;
import com.cognos.xqe.transformation.v5.SetV5DataItemIsProjected;
import com.cognos.xqe.util.Governors;
import com.cognos.xqemoser.MoserLevel;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserQueryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class NormalizeMoserMetadata
extends Transformation {
    protected static final String APPLIED = "moserQueryItemToLevel";
    public static final String EMPTY_VUN = "[]";
    private static final int[] OLAP_FUNCS = new int[]{201106, 201047, 201107, 201048, 201066, 201111, 201064, 201148, 201074, 201062, 201053, 201071, 201110, 201149};
    private static final int[] OLAP_FUNCS_EXT = ArrayUtils.add((int[])OLAP_FUNCS, (int)201039);
    protected static final int[] TYPES_VUN_TO_LITERAL = NormalizeMoserMetadata.initializeTypesVunToLiteral();

    private static int[] initializeTypesVunToLiteral() {
        int[] types = new int[]{201101, 201011, 201013};
        Arrays.sort(types);
        return types;
    }

    public NormalizeMoserMetadata() {
        this.mName = "Normalize Moser Metadata.";
        this.mPassNumbers = new int[]{32};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        query.setPropertyValue(APPLIED, Boolean.TRUE);
        IXQEQueryNode[] diRefs = query.getDescendantsOfType(201060, false);
        while (diRefs.length > 0) {
            for (IXQEQueryNode r : diRefs) {
                ExpandDataItemReferences.processNode(r, environment);
            }
            diRefs = query.getDescendantsOfType(201060, false);
        }
        HashSet<V5BoundValueUniqueName> vuns = new HashSet<V5BoundValueUniqueName>();
        HashSet<V5BoundMemberUniqueName> muns = new HashSet<V5BoundMemberUniqueName>();
        ArrayList<InfoClass> metas = new ArrayList<InfoClass>();
        boolean[] bOLAP = new boolean[]{false};
        this.getVunAndMunAndMeta(query, vuns, muns, metas, bOLAP);
        XQENodeFactory nf = environment.getNodeFactory();
        HashMap<MoserLevel, MoserQueryItem> moserLevelToQueryItem = new HashMap<MoserLevel, MoserQueryItem>();
        for (V5BoundValueUniqueName vun : vuns) {
            Governors.DMREmptyMUNTreatment emptyMUN = null;
            MoserQueryItem queryItem = (MoserQueryItem)vun.getMetadata();
            MoserLevel level = queryItem.getOrCreateLevel();
            moserLevelToQueryItem.put(level, queryItem);
            String logicalPart = vun.getLogical();
            String externalMUN = null;
            if ("all".equals(logicalPart)) {
                level = (MoserLevel)level.getHierarchy().getLevel(0);
                externalMUN = "[all]";
            } else {
                String v = logicalPart;
                if (vun.getLogical() == null) {
                    v = EMPTY_VUN;
                    emptyMUN = Governors.DMREmptyMUNTreatment.ASNULL;
                }
                externalMUN = "[all]." + v;
            }
            V5BoundMemberUniqueName v5BoundMemberUniqueName = (V5BoundMemberUniqueName)nf.createNode(201117);
            v5BoundMemberUniqueName.setExternalMemberUniqueName(externalMUN);
            v5BoundMemberUniqueName.setLevel(level);
            v5BoundMemberUniqueName.setNativeName(level.getV5UniqueName() + "->" + externalMUN);
            v5BoundMemberUniqueName.setLogical(externalMUN);
            if (emptyMUN != null) {
                v5BoundMemberUniqueName.setPropertyValue("dmrEmptyMUN", (Object)emptyMUN);
            }
            vun.exchange(v5BoundMemberUniqueName);
        }
        for (InfoClass md : metas) {
            this.convertQyeryItemToLevel(md, moserLevelToQueryItem);
            this.convertQyeryItemToLevelIndirect(md, moserLevelToQueryItem);
        }
    }

    protected void convertQyeryItemToLevel(InfoClass info, HashMap<MoserLevel, MoserQueryItem> moserLevelToQueryItem) {
        MoserQueryItem moserQI;
        IMetadata meta;
        HashSet<V5BoundModelIdentifier> workingSet = new HashSet<V5BoundModelIdentifier>();
        HashSet<V5BoundModelIdentifier> moserFacet = new HashSet<V5BoundModelIdentifier>();
        for (V5BoundModelIdentifier mdObj : info.mds) {
            IFacet f;
            meta = mdObj.getMetadata();
            if (meta == null || meta.isDMR() || !(meta instanceof MoserQueryItem) || !"identifier".equals((moserQI = (MoserQueryItem)meta).getUsage()) && !"attribute".equals(moserQI.getUsage()) || (f = moserQI.getFacet()) == null || !f.isEnabled()) continue;
            if (this.needConvertToLevel(mdObj.getParent(), info)) {
                workingSet.add(mdObj);
                continue;
            }
            moserFacet.add(mdObj);
        }
        info.mds = moserFacet;
        for (V5BoundModelIdentifier mdObj : workingSet) {
            meta = mdObj.getMetadata();
            moserQI = (MoserQueryItem)meta;
            MoserLevel level = moserQI.getOrCreateLevel();
            moserLevelToQueryItem.put(level, moserQI);
            mdObj.setMetadata(level);
        }
    }

    protected void convertQyeryItemToLevelIndirect(InfoClass info, HashMap<MoserLevel, MoserQueryItem> moserLevelToQueryItem) {
        for (V5BoundModelIdentifier mdObj : info.mds) {
            MoserQueryItem moserQI = (MoserQueryItem)mdObj.getMetadata();
            MoserLevel level = null;
            for (Map.Entry<MoserLevel, MoserQueryItem> entry : moserLevelToQueryItem.entrySet()) {
                if (!moserQI.equals(entry.getValue())) continue;
                level = entry.getKey();
                break;
            }
            if (level == null || !this.checkMoserLevel(level, mdObj, info.top)) continue;
            mdObj.setMetadata(level);
        }
    }

    protected IXQEQueryNode getAncestor(IXQEQueryNode obj, IXQEQueryNode anch, HashSet<Integer> anTypes) {
        V5CaseExpression caseStm;
        IXQEQueryNode parent = obj.getParent();
        if (parent == null || parent.equals(anch)) {
            return null;
        }
        int tp = parent.getType();
        if (anTypes.contains(tp)) {
            return parent;
        }
        if (tp == 201017 || tp == 201019 ? obj.equals(parent.getChild(0)) : tp == 201018 && (caseStm = (V5CaseExpression)parent).getSubType() == 0 && obj.equals(parent.getChild(0))) {
            return null;
        }
        return this.getAncestor(parent, anch, anTypes);
    }

    protected boolean checkMoserLevel(MoserLevel level, V5BoundModelIdentifier aMDObj, IXQEQueryNode anch) {
        HashSet<Integer> anTypes = new HashSet<Integer>();
        for (int t : OLAP_FUNCS_EXT) {
            anTypes.add(t);
        }
        for (int t : TYPES_VUN_TO_LITERAL) {
            anTypes.add(t);
        }
        IXQEQueryNode an = this.getAncestor(aMDObj, anch, anTypes);
        if (an == null) {
            return false;
        }
        InfoClass info = new InfoClass();
        info.top = an;
        HashSet<V5BoundValueUniqueName> vuns = new HashSet<V5BoundValueUniqueName>();
        HashSet<V5BoundMemberUniqueName> muns = new HashSet<V5BoundMemberUniqueName>();
        boolean[] bOLAP = new boolean[]{false};
        this.getVUNAndMUNFromExpr(an, vuns, muns, info, bOLAP);
        for (V5BoundMemberUniqueName mun : muns) {
            ILevel lvl = mun.getLevel();
            if (!level.equals(lvl)) continue;
            return true;
        }
        for (V5BoundModelIdentifier mdObj : info.mds) {
            IMetadata meta;
            if (aMDObj.equals(mdObj) || !level.equals(meta = mdObj.getMetadata())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!this.needNormalizeMoserMetadata(environment, node)) {
            this.traceNodeCondition(false, "no need to normalize Moser metadata.", trace);
            return false;
        }
        this.traceNodeCondition(true, "need to normalize Moser metadata.", trace);
        return true;
    }

    protected HashSet<String> getProjectedDataItems(V5Query query, HashSet<String> sortDI) {
        HashSet<String> rt = new HashSet<String>();
        V5QuerySet v5QuerySet = (V5QuerySet)query.getAncestorOfType(101002);
        List<V5QueryResultDefinition> qrds = v5QuerySet.getReferencedQRDs(query);
        int[] types = new int[]{101015, 101057};
        for (V5QueryResultDefinition qrd : qrds) {
            IXQEQueryNode[] nodes;
            for (IXQEQueryNode n : nodes = qrd.getDescendantsOfTypes(types, false)) {
                V5SortItem sortItem;
                String dataItemName = SetV5DataItemIsProjected.getDataItemName(n);
                if (dataItemName != null) {
                    rt.add(dataItemName);
                }
                if (n.getType() != 101056 || (dataItemName = (sortItem = (V5SortItem)n).getRefDataItem()) == null) continue;
                sortDI.add(dataItemName);
            }
        }
        return rt;
    }

    protected void getVunAndMunAndMeta(V5Query query, HashSet<V5BoundValueUniqueName> vuns, HashSet<V5BoundMemberUniqueName> muns, List<InfoClass> metas, boolean[] bOLAP) {
        IXQEQueryNode[] slicers;
        IXQEQueryNode[] sumFilters;
        IXQEQueryNode[] filters;
        InfoClass info;
        IXQEQueryNode[] dataItems;
        HashSet<String> sortDI = new HashSet<String>();
        HashSet<String> projectedDataItems = this.getProjectedDataItems(query, sortDI);
        V5Selection v5selection = query.getV5Selection();
        for (IXQEQueryNode di : dataItems = v5selection.getChildrenOfType(101003)) {
            V5DataItem v5DI = (V5DataItem)di;
            String diName = v5DI.getNameProperty();
            if (!projectedDataItems.contains(diName) && !sortDI.contains(diName)) continue;
            info = new InfoClass();
            info.bProj = projectedDataItems.contains(diName);
            info.top = v5DI;
            this.getVUNAndMUNFromExpr(di, vuns, muns, info, bOLAP);
            if (info.mds.isEmpty()) continue;
            metas.add(info);
        }
        for (IXQEQueryNode f : filters = query.getV5DetailFilters()) {
            InfoClass info2 = new InfoClass();
            info2.top = f;
            this.getVUNAndMUNFromExpr(f, vuns, muns, info2, bOLAP);
            if (info2.mds.isEmpty()) continue;
            metas.add(info2);
        }
        for (IXQEQueryNode sf : sumFilters = query.getV5SummaryFilters()) {
            info = new InfoClass();
            info.top = sf;
            this.getVUNAndMUNFromExpr(sf, vuns, muns, info, bOLAP);
            if (info.mds.isEmpty()) continue;
            metas.add(info);
        }
        for (IXQEQueryNode sl : slicers = query.getV5Slicers()) {
            InfoClass info3 = new InfoClass();
            info3.top = sl;
            this.getVUNAndMUNFromExpr(sl, vuns, muns, info3, bOLAP);
            if (info3.mds.isEmpty()) continue;
            metas.add(info3);
        }
    }

    protected void getVUNAndMUNFromExpr(IXQEQueryNode exp, HashSet<V5BoundValueUniqueName> vuns, HashSet<V5BoundMemberUniqueName> muns, InfoClass info, boolean[] bOLAP) {
        IXQEQueryNode[] nodes;
        IXQEQueryNode[] refs;
        for (IXQEQueryNode ref : refs = exp.getDescendantsOfType(201060, true)) {
            V5BoundDataItemReference diRef = (V5BoundDataItemReference)ref;
            V5DataItem refDI = diRef.getRefDataItem();
            if (refDI == null) continue;
            HashSet<V5BoundDataItemReference> refToDI = info.v5DIToRef.get(refDI);
            if (refToDI == null) {
                refToDI = new HashSet();
                info.v5DIToRef.put(refDI, refToDI);
            }
            refToDI.add(diRef);
            this.getVUNAndMUNFromExpr(refDI, vuns, muns, info, bOLAP);
        }
        int[] types = new int[]{201118, 201117, 201116};
        for (IXQEQueryNode n : nodes = exp.getDescendantsOfTypes(types, true)) {
            int t = n.getType();
            if (201118 == t) {
                vuns.add((V5BoundValueUniqueName)n);
                continue;
            }
            if (201117 == t) {
                muns.add((V5BoundMemberUniqueName)n);
                continue;
            }
            info.mds.add((V5BoundModelIdentifier)n);
        }
        if (!bOLAP[0]) {
            bOLAP[0] = this.hasOLAPFunctions(exp);
        }
    }

    protected boolean needNormalizeMoserMetadata(PlanningEnvironment environment, IXQEQueryNode node) {
        V5Query query = (V5Query)node;
        Boolean b = (Boolean)node.getPropertyValue(APPLIED);
        if (Boolean.TRUE.equals(b)) {
            return false;
        }
        if (query.isRelationalSubquery()) {
            return false;
        }
        MetadataConnection mdConn = environment.getMetadataConnection();
        if (!(mdConn instanceof MoserMetadataConnection)) {
            return false;
        }
        MoserMetadataConnection moserConnection = (MoserMetadataConnection)mdConn;
        if (moserConnection.hasFMPackage()) {
            return false;
        }
        HashSet<V5BoundValueUniqueName> vuns = new HashSet<V5BoundValueUniqueName>();
        HashSet<V5BoundMemberUniqueName> muns = new HashSet<V5BoundMemberUniqueName>();
        ArrayList<InfoClass> metas = new ArrayList<InfoClass>();
        boolean[] bOLAP = new boolean[]{false};
        this.getVunAndMunAndMeta(query, vuns, muns, metas, bOLAP);
        boolean rt = false;
        for (V5BoundValueUniqueName vun : vuns) {
            IXQEQueryNode parent;
            int type;
            int idx;
            IMetadata meta = vun.getMetadata();
            if (!(meta instanceof MoserQueryItem)) {
                return false;
            }
            if ("all".equals(vun.getLogical())) {
                rt = true;
            }
            if ((idx = Arrays.binarySearch(TYPES_VUN_TO_LITERAL, type = (parent = vun.getParent()).getType())) >= 0) continue;
            rt = true;
        }
        if (rt) {
            return rt;
        }
        if (!vuns.isEmpty() && !muns.isEmpty()) {
            return true;
        }
        boolean hasRelNoMeasure = false;
        boolean hasDMR = false;
        for (InfoClass info : metas) {
            for (V5BoundModelIdentifier mdObj : info.mds) {
                IMetadata meta = mdObj.getMetadata();
                if (meta == null) {
                    return false;
                }
                if (meta.isDMR()) {
                    hasDMR = true;
                    continue;
                }
                if (!(meta instanceof MoserQueryItem)) continue;
                MoserQueryItem moserQI = (MoserQueryItem)meta;
                hasRelNoMeasure |= this.queryItemUsedAsLevel(mdObj, moserQI, info);
            }
        }
        if (hasDMR) {
            return !vuns.isEmpty() || hasRelNoMeasure;
        }
        if (hasRelNoMeasure) {
            return !muns.isEmpty() || bOLAP[0];
        }
        return false;
    }

    private boolean queryItemUsedAsLevel(IXQEQueryNode boundID, MoserQueryItem moserQI, InfoClass info) {
        IFacet f;
        if (("identifier".equals(moserQI.getUsage()) || "attribute".equals(moserQI.getUsage())) && (f = moserQI.getFacet()) != null && f.isEnabled()) {
            return this.needConvertToLevel(boundID.getParent(), info);
        }
        return false;
    }

    private boolean needConvertToLevel(IXQEQueryNode obj, InfoClass info) {
        if (obj == null) {
            return false;
        }
        if (obj.equals(info.top)) {
            int topType = info.top.getType();
            if (topType != 101003 || !info.bProj) {
                return false;
            }
            V5DataItem topDI = (V5DataItem)info.top;
            String aggr = topDI.getAggregateProperty();
            return aggr == null || "none".equals(aggr) || "automatic".equals(aggr);
        }
        int tp = obj.getType();
        if (IntStream.of(OLAP_FUNCS_EXT).anyMatch(x -> x == tp)) {
            return true;
        }
        if (tp == 101013 || tp == 101008 || tp == 101011) {
            return false;
        }
        if (tp == 101004) {
            return this.needConvertToLevel(obj.getParent(), info);
        }
        if (tp != 101003) {
            return false;
        }
        HashSet<V5BoundDataItemReference> dIRefs = info.v5DIToRef.get((V5DataItem)obj);
        if (dIRefs != null) {
            for (IXQEQueryNode iXQEQueryNode : dIRefs) {
                if (!this.needConvertToLevel(iXQEQueryNode.getParent(), info)) continue;
                return true;
            }
        } else {
            IXQEQueryNode parent = obj.getParent();
            if (parent == null || parent.getType() == 101009) {
                return false;
            }
            return this.needConvertToLevel(parent, info);
        }
        return false;
    }

    protected boolean hasOLAPFunctions(IXQEQueryNode node) {
        IXQEQueryNode[] olaps = node.getDescendantsOfTypes(OLAP_FUNCS, false);
        return olaps.length > 0;
    }

    protected static final class InfoClass {
        protected HashSet<V5BoundModelIdentifier> mds = new HashSet();
        protected IXQEQueryNode top = null;
        protected boolean bProj = false;
        protected HashMap<V5DataItem, HashSet<V5BoundDataItemReference>> v5DIToRef = new HashMap();

        protected InfoClass() {
        }
    }
}

