/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveUnreferencedQueries
extends Transformation {
    public RemoveUnreferencedQueries() {
        this.mName = "Remove unreferenced queries.";
        this.mPassNumbers = new int[]{25};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] queries = node.getParent().getChildrenOfType(101006);
        this.removeQueryReferences(queries, (V5Query)node, environment);
        node.detach();
    }

    void removeQueryReferences(IXQEQueryNode[] queries, V5Query query, PlanningEnvironment environment) {
        for (IXQEQueryNode current : queries) {
            V5Query currentQuery = (V5Query)current;
            if (!currentQuery.isReferenced()) continue;
            V5Source v5Source = currentQuery.getV5Source();
            if (v5Source.removeQueryReference(query.getV5QueryName())) {
                ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ReferencedQueryWithoutProjectedDataItems, currentQuery.getRootQueryName(), query.getRootQueryName());
                environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
                continue;
            }
            if (!v5Source.isQueryReferencedInQueryOperation(query)) continue;
            V5QueryOperation queryOpNode = (V5QueryOperation)v5Source.getFirstChildByType(101018);
            queryOpNode.detach();
            StringBuffer sb = new StringBuffer();
            IXQEQueryNode[] queryRefsOfQueryOp = queryOpNode.getChildrenOfType(101023);
            for (int i = 0; i < queryRefsOfQueryOp.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                V5QueryRef queryRef = (V5QueryRef)queryRefsOfQueryOp[i];
                sb.append(queryRef.getRefQuery());
            }
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ReferencedQueryOperationWithoutProjectedDataItems, currentQuery.getV5QueryName(), queryOpNode.getName(), sb.toString());
            environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.isReferenced()) {
            this.traceNodeCondition(false, "The query is referenced.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The query is not referenced.", trace);
        return true;
    }
}

