/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5MemberAnalyticFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class SetDataItemCustomFormatProperty
extends Transformation {
    public SetDataItemCustomFormatProperty() {
        this.mName = "Resolve format for projected DataItem in QRD";
        this.mPassNumbers = new int[]{23, 26};
        this.mTypes = new int[]{101003, 801008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String format = null;
        if (node.getType() == 101003) {
            format = ((V5QueryNode)node).getFormat();
        }
        if (node.getType() == 801008) {
            format = ((RQPDataItem)node).getFormat();
        }
        if (format != null) {
            node.setPropertyValue("customFormat", format);
        }
        IXQEQueryNode[] formatFunctions = node.getDescendantsOfType(201069, true);
        for (int index = 0; index < formatFunctions.length; ++index) {
            formatFunctions[index].extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "DataItem has invalid number of children.", trace);
            return status;
        }
        boolean bl = status = node.getDescendantsOfType(201069, true).length != 0;
        if (!status) {
            if (node.getType() == 101003 && ((V5DataItem)node).getPropertyValue("customFormat") != null || node.getType() == 801008 && ((RQPDataItem)node).getPropertyValue("customFormat") != null) {
                this.traceNodeCondition(false, "DataItem has already set the custom format", trace);
                return status;
            }
            IXQEQueryNode[] nodes = node.getDescendantsOfType(201034, true);
            for (int i = 0; i < nodes.length && !status; ++i) {
                if (((V5MemberAnalyticFunction)nodes[i]).getSubType() != 16 && ((V5MemberAnalyticFunction)nodes[i]).getSubType() != 15) continue;
                status = true;
            }
        }
        if (status) {
            String format = null;
            if (node.getType() == 101003) {
                format = ((V5QueryNode)node).getFormat();
            }
            if (node.getType() == 801008) {
                format = ((RQPDataItem)node).getFormat();
            }
            IXQEQueryNode[] formatFunctions = node.getDescendantsOfType(201069, true);
            boolean bl2 = status = format != null || formatFunctions.length > 0;
        }
        if (status) {
            this.traceNodeCondition(true, "Custom Format can be resolved.", trace);
        } else {
            this.traceNodeCondition(false, "No need to override default format.", trace);
        }
        return status;
    }
}

