/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.metadata.IFunction;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FDSException;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import com.cognos.xqe.util.fds.IFunctionParameter;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class UpdateV5GenericFunctionDatatype
extends Transformation {
    public UpdateV5GenericFunctionDatatype(int[] passNumbers) {
        this.mName = "Update the return data type of a V5GenericFunction";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201042};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5GenericFunction v5GenericFunc = (V5GenericFunction)node;
        IDataType dataType = this.getDataTypeFromMetadata(v5GenericFunc, environment);
        if (dataType == null) {
            dataType = this.getDataTypeFromFDS(v5GenericFunc, environment);
        }
        v5GenericFunc.setDataType(dataType);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5GenericFunction v5GenericFunc = (V5GenericFunction)node;
        IDataType dataType = null;
        if (v5GenericFunc.getDataType() == VariantType.VARIANT && (dataType = this.getDataTypeFromMetadata(v5GenericFunc, environment)) == null) {
            dataType = this.getDataTypeFromFDS(v5GenericFunc, environment);
        }
        if (dataType == v5GenericFunc.getDataType()) {
            this.traceQueryCondition(false, "Return data type of generic function does not need any updating.", trace);
            return false;
        }
        if (dataType != null && dataType.getSubType() != DataSubType.UNKNOWN && dataType.getSubType() != DataSubType.VARIANTTYPE) {
            this.traceQueryCondition(true, "Return data type of generic function can be updated.", trace);
            return true;
        }
        this.traceQueryCondition(false, "Return data type of generic function cannot be updated.", trace);
        return false;
    }

    IDataType getDataTypeFromMetadata(V5GenericFunction v5GenericFunc, PlanningEnvironment environment) {
        MetadataConnection mdConnection = environment.getMetadataConnection();
        IFunction mdFunc = (IFunction)mdConnection.getFunction(v5GenericFunc.getName());
        IDataType dataType = null;
        boolean status = false;
        if (mdFunc != null && (status = this.compareParameterDataTypeMetadata(v5GenericFunc, mdFunc))) {
            dataType = mdFunc.getDataType();
        }
        return dataType;
    }

    IDataType getDataTypeFromFDS(V5GenericFunction v5GenericFunc, PlanningEnvironment environment) {
        ArrayList<IFunctionNode> funcList = null;
        LinkedHashSet<IFunctionNode> filteredFuncList = new LinkedHashSet<IFunctionNode>();
        IDataType dataType = null;
        MetadataConnection mdConnection = environment.getMetadataConnection();
        IFunctionDefinition funcDef = IFunctionDefinition.Factory.createFDAllLocales();
        List<IModelDataSource> dataSources = mdConnection.getModelDataSources();
        List<String> vendorIDList = mdConnection.getModelFunctionSetVendorIDs();
        for (String vendorID : vendorIDList) {
            funcDef.addVendorFunctionSetFilter(vendorID);
        }
        funcDef.addContextFiltersForCQE();
        funcDef.showHidden();
        try {
            funcList = funcDef.findFuncListByName(v5GenericFunc.getName());
        }
        catch (FDSException e) {
            return null;
        }
        for (IModelDataSource ds : dataSources) {
            String interfaceID = ds.getInterface();
            if (interfaceID == null) continue;
            for (IFunctionNode func : funcList) {
                if (!func.isSupportedByModelDatasourceInterfaceID(interfaceID)) continue;
                filteredFuncList.add(func);
            }
        }
        if (filteredFuncList.size() == 1) {
            IFunctionNode f = (IFunctionNode)filteredFuncList.iterator().next();
            String formatString = f.getFormatType();
            v5GenericFunc.setPropertyValue("fdsFormatString", formatString);
            return this.resolveFDSFunctionReturnType(v5GenericFunc, f.getReturnType());
        }
        for (IFunctionNode funcNode : filteredFuncList) {
            if (!this.compareParameterDataTypeFDS(v5GenericFunc, funcNode)) continue;
            FDSDataTypeEnum returnDataType = funcNode.getReturnType();
            dataType = this.resolveFDSFunctionReturnType(v5GenericFunc, returnDataType);
            String formatString = funcNode.getFormatType();
            v5GenericFunc.setPropertyValue("fdsFormatString", formatString);
            break;
        }
        return dataType;
    }

    private IDataType resolveFDSFunctionReturnType(V5GenericFunction v5GenericFunc, FDSDataTypeEnum fdsFuncReturnType) {
        if (fdsFuncReturnType == null) {
            return null;
        }
        int ordinalNumber = fdsFuncReturnType.getParameterDataTypePosition();
        if (ordinalNumber != -1 && ordinalNumber > 0 && ordinalNumber <= v5GenericFunc.getNumberChildren()) {
            IXQEQueryNode child = v5GenericFunc.getChild(ordinalNumber - 1);
            if (child.getType() == 101003) {
                child = ((V5DataItem)child).getDetailExpression();
            }
            V5SimpleNode child1 = (V5SimpleNode)child;
            return child1.getDataType();
        }
        return V5GenericFunction.getDataType(fdsFuncReturnType);
    }

    private boolean compareParameterDataTypeMetadata(V5GenericFunction v5GenericFunc, IFunction metadataFunc) {
        boolean status;
        List<IProcParameter> procParams = metadataFunc.getProcParameters();
        boolean bl = status = v5GenericFunc.getNumberChildren() == procParams.size();
        if (status) {
            for (int j = 0; j < procParams.size() && status; ++j) {
                IXQEQueryNode child = v5GenericFunc.getChild(j);
                IProcParameter parm = procParams.get(j);
                IDataType childDataType = null;
                if (child instanceof V5SimpleNode) {
                    childDataType = ((V5SimpleNode)child).getDataType();
                } else if (child instanceof V5DataItem) {
                    childDataType = ((V5DataItem)child).getDataType();
                }
                IDataType parmDataType = parm.getDataType();
                if (childDataType != null && parmDataType != null && DataTypeComparator.isComparableTo(childDataType, parmDataType)) continue;
                status = false;
            }
        }
        return status;
    }

    private boolean compareParameterDataTypeFDS(V5GenericFunction v5GenericFunc, IFunctionNode funcNode) {
        int parmSize;
        boolean status;
        ArrayList<IFunctionParameter> parameters = funcNode.getParameters();
        int numberChildren = v5GenericFunc.getNumberChildren();
        boolean bl = status = numberChildren <= (parmSize = parameters.size());
        if (status) {
            int i;
            block0: for (i = 0; i < numberChildren && status; ++i) {
                IXQEQueryNode child = v5GenericFunc.getChild(i);
                IFunctionParameter parm = parameters.get(i);
                IDataType childDataType = null;
                if (child instanceof V5SimpleNode) {
                    childDataType = ((V5SimpleNode)child).getDataType();
                } else if (child instanceof V5DataItem) {
                    childDataType = ((V5DataItem)child).getDataType();
                }
                IDataType parmDataType = null;
                List<FDSDataTypeEnum> paramTypes = parm.getTypes();
                for (FDSDataTypeEnum paramType : paramTypes) {
                    parmDataType = V5GenericFunction.getDataType(paramType);
                    if (childDataType != VariantType.VARIANT && parmDataType == VariantType.VARIANT) {
                        status = true;
                        continue block0;
                    }
                    if (childDataType == null || parmDataType == null || !DataTypeComparator.isComparableTo(childDataType, parmDataType)) {
                        status = false;
                        continue;
                    }
                    status = true;
                    continue block0;
                }
            }
            while (i < parmSize && status) {
                IFunctionParameter parm = parameters.get(i);
                if (parm.getMinOccurs() > 0) {
                    status = false;
                }
                ++i;
            }
        }
        return status;
    }
}

