/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.util.V5MunUtil;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.missingMember.MissingMember;
import com.cognos.xqe.query.missingMember.MissingMemberException;
import com.cognos.xqe.trace.XQETrace;
import java.util.Map;

public final class ValidateMUNBinding
extends Transformation {
    public ValidateMUNBinding() {
        this.mName = "Validate whether the mun binding is succesful.";
        this.mPassNumbers = new int[]{30};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Map<String, MissingMember> missingMemberList = reqEnv.getRequestMissingMembers();
        V5Query query = (V5Query)node;
        String munToThrow = null;
        int aSeverity = 0;
        IXQEQueryNode[] muns = query.getDescendantsOfType(201028, false);
        for (int idx = 0; idx < muns.length; ++idx) {
            String mun;
            V5MemberUniqueName v5Mun = (V5MemberUniqueName)muns[idx];
            if (!V5MunUtil.isMunBindingFailed(v5Mun)) continue;
            IXQEQueryNode dataItem = v5Mun.getAncestorOfType(101003);
            MissingMember tNodeMM = new MissingMember();
            String queryName = (String)query.getPropertyValue("name");
            String dataItemName = dataItem != null ? (String)dataItem.getPropertyValue("name") : "unknown";
            tNodeMM.setQueryName(queryName);
            tNodeMM.setRefDataItem(dataItemName);
            munToThrow = mun = v5Mun.getNativeName();
            missingMemberList.put(mun, tNodeMM);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, mun));
        }
        if (munToThrow != null) {
            throw new MissingMemberException(reqEnv, munToThrow);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        boolean hasInvalidMunModelRef = false;
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        IXQEQueryNode[] muns = query.getDescendantsOfType(201028, false);
        for (int idx = 0; idx < muns.length; ++idx) {
            V5MemberUniqueName v5Mun = (V5MemberUniqueName)muns[idx];
            if (!V5MunUtil.isMunBindingFailed(v5Mun)) continue;
            hasInvalidMunModelRef = true;
        }
        if (!hasInvalidMunModelRef) {
            this.traceNodeCondition(status, "The members in the query are valid mun.", trace);
            return status;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Map<String, MissingMember> missingMemberList = reqEnv.getRequestMissingMembers();
        if (missingMemberList.size() > 0) {
            this.traceNodeCondition(status, "Muns already validated.", trace);
            return status;
        }
        status = true;
        this.traceNodeCondition(status, "The query has invalid mun, need to add it to missing member list.", trace);
        return status;
    }
}

