/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.Transformation;

public abstract class AbstractCoerceSetExpression
extends Transformation {
    private static final String CLOSING_BRACKET = ").";

    public static void coerceToSetExpression(IXQEQueryNode setExpr, IXQENodeFactory nodeFactory) {
        boolean valid;
        IXQEQueryNode exprToCoerce = setExpr;
        while (exprToCoerce.getType() == 101003) {
            exprToCoerce = exprToCoerce.getChild(0);
        }
        if (exprToCoerce.isOfCategory(201125)) {
            return;
        }
        boolean requiresSetFunction = exprToCoerce.isOfCategories(new int[]{201121, 201123, 201117});
        boolean requiresMembersFunction = exprToCoerce.isOfTypes(new int[]{201073, 201082, 201083});
        boolean bl = valid = requiresSetFunction || requiresMembersFunction;
        if (exprToCoerce.isOfCategory(201116)) {
            V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(exprToCoerce);
            if (expressionType == V5ExpressionTypeEnum.MEMBER) {
                requiresSetFunction = true;
                valid = true;
            } else if (expressionType == V5ExpressionTypeEnum.LEVEL || expressionType == V5ExpressionTypeEnum.HIERARCHY) {
                requiresMembersFunction = true;
                valid = true;
            } else {
                valid = false;
            }
        }
        if (exprToCoerce.getType() == 201127 && !((V5BoundParameter)exprToCoerce).isLiteral() || exprToCoerce.getType() == 201024 && !((V5Parameter)exprToCoerce).isLiteral()) {
            requiresSetFunction = true;
            valid = true;
        }
        if (!valid) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid operand in call to V5Builder.coerceToSetExpression(" + exprToCoerce.dumpToString() + CLOSING_BRACKET);
        }
        if (exprToCoerce.isOfCategory(201123)) {
            IXQEQueryNode v5Member = nodeFactory.createNode(201085);
            ((V5MemberFunction)v5Member).setPlannerV5MemberFn(true);
            exprToCoerce.insertParent(v5Member);
            exprToCoerce = v5Member;
        }
        int type = 201101;
        if (requiresMembersFunction) {
            type = 201086;
        }
        V5SimpleNode setExpression = (V5SimpleNode)nodeFactory.createNode(type);
        setExpression.setIsCoercion(true);
        exprToCoerce.insertParent(setExpression);
    }

    boolean requiresSetCoercion(IXQEQueryNode node) {
        boolean requiresCoercion = false;
        if (!V5ExpressionCheck.isSetExpression(node) && V5ExpressionCheck.shouldBeCoercedToSet(node)) {
            if (V5ExpressionCheck.canBeCoercedToSet(node)) {
                requiresCoercion = true;
            } else {
                V5ExpressionCheck.throwInvalidCoercionException(node, V5ExpressionTypeEnum.SET);
            }
        }
        return requiresCoercion;
    }
}

