/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5TupleFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueFunction;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.Transformation;

public abstract class AbstractCoerceValueExpression
extends Transformation {
    private static final String CLOSING_BRACKET = ").";

    public static void coerceToValueExpression(IXQEQueryNode valueExpr, IXQENodeFactory nodeFactory) {
        V5ExpressionTypeEnum exprType = V5ExpressionCheck.getExpressionType(valueExpr);
        IXQEQueryNode exprToCoerce = valueExpr;
        while (exprToCoerce.getType() == 101003) {
            exprToCoerce = exprToCoerce.getChild(0);
        }
        if (exprType != V5ExpressionTypeEnum.MEMBER && exprType != V5ExpressionTypeEnum.TUPLE) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid operand in call to V5Builder.coerceToValueExpression(" + valueExpr.dumpToString() + CLOSING_BRACKET);
        }
        if (exprType == V5ExpressionTypeEnum.MEMBER) {
            V5TupleFunction v5Tuple = (V5TupleFunction)nodeFactory.createNode(201110);
            v5Tuple.setIsCoercion(true);
            exprToCoerce.insertParent(v5Tuple);
            exprToCoerce = v5Tuple;
        }
        V5ValueFunction valueFunction = (V5ValueFunction)nodeFactory.createNode(201113);
        valueFunction.setIsCoercion(true);
        exprToCoerce.insertParent(valueFunction);
    }

    static boolean requiresValueCoercion(IXQEQueryNode node) {
        boolean requiresCoercion = false;
        if (!V5ExpressionCheck.isValueExpression(node) && V5ExpressionCheck.shouldBeCoercedToValue(node)) {
            if (V5ExpressionCheck.canBeCoercedToValueExpression(node)) {
                requiresCoercion = true;
            } else {
                V5ExpressionCheck.throwInvalidCoercionException(node, V5ExpressionTypeEnum.VALUE);
            }
        }
        return requiresCoercion;
    }

    static boolean requiresTupleCoercion(IXQEQueryNode node) {
        IMetadata metaData;
        IXQEQueryNode exprToCoerce = node.getChild(0);
        while (exprToCoerce.getType() == 101003) {
            exprToCoerce = exprToCoerce.getChild(0);
        }
        if (exprToCoerce.isOfCategory(201123)) {
            return false;
        }
        boolean canBeCoerced = false;
        if (exprToCoerce.isOfCategory(201116) && (metaData = ((V5BoundModelIdentifier)exprToCoerce).getMetadata()).getObjectType() == MetadataType.MEMBER) {
            canBeCoerced = true;
        }
        if (exprToCoerce.isOfCategory(201121) || exprToCoerce.isOfCategory(201117)) {
            canBeCoerced = true;
        }
        if (!canBeCoerced) {
            V5ExpressionCheck.throwInvalidCoercionException(exprToCoerce, V5ExpressionTypeEnum.TUPLE);
        }
        return canBeCoerced;
    }
}

