/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceValueExpression;

public final class CoerceCaseExpressionElseArg
extends AbstractCoerceValueExpression {
    public CoerceCaseExpressionElseArg() {
        this.mName = "Coerce Case Expressions - the else argument";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201018};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode lastChild = node.getChild(node.getNumberChildren() - 1);
        CoerceCaseExpressionElseArg.coerceToValueExpression(lastChild, nodeFactory);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getBooleanPropertyValue("isCaseCouldBeCollapsed") == Boolean.TRUE) {
            this.traceNodeCondition(status, "The case expression could have been collapsed.", trace);
        } else {
            IXQEQueryNode lastChild = node.getChild(node.getNumberChildren() - 1);
            if (lastChild != null && lastChild.getType() != 201019) {
                status = CoerceCaseExpressionElseArg.requiresValueCoercion(lastChild);
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "The last child node don't need coercion.", trace);
        } else {
            this.traceNodeCondition(status, "The last child node is else clause and need coercion.", trace);
        }
        return status;
    }
}

