/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqemoser.MoserHierarchy;
import com.cognos.xqemoser.MoserMetadataConnection;

public final class CoerceMemberSummaryToMember
extends Transformation {
    public CoerceMemberSummaryToMember() {
        this.mName = "Coerce Member Summary to Member";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{201032};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode v5Member = nodeFactory.createNode(201085);
        ((V5MemberFunction)v5Member).setPlannerV5MemberFn(true);
        node.insertParent(v5Member);
        V5LiteralValue munV = (V5LiteralValue)nodeFactory.createNode(201026);
        String mun = "Coerced";
        munV.setDataType(DataTypeFactory.getVarcharType(mun.length()));
        munV.setValue(mun);
        v5Member.addChild(munV);
        V5LiteralValue capV = (V5LiteralValue)nodeFactory.createNode(201026);
        String caption = mun;
        capV.setDataType(DataTypeFactory.getVarcharType(caption.length()));
        capV.setValue(caption);
        v5Member.addChild(capV);
        MDXHierInfo hierInfo = ((V5MemberSummaryFunction)node).getSetHierarchyInfo(true);
        V5BoundModelIdentifier mIdentifier = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        IHierarchy hier = hierInfo.getProjectedHierarchy(0);
        mIdentifier.setMetadata(hier);
        mIdentifier.setIdentifier(hier.getV5UniqueName());
        v5Member.addChild(mIdentifier);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = this.needCoerce(environment, node);
        if (status) {
            this.traceNodeCondition(status, "need to coerce to member.", trace);
        } else {
            this.traceNodeCondition(status, "no need.", trace);
        }
        return status;
    }

    protected boolean needCoerce(PlanningEnvironment environment, IXQEQueryNode node) {
        boolean b;
        IXQEQueryNode parentNode;
        MetadataConnection mdConn = environment.getMetadataConnection();
        if (!(mdConn instanceof MoserMetadataConnection)) {
            return false;
        }
        for (parentNode = node.getParent(); parentNode != null && parentNode.getType() == 101003; parentNode = parentNode.getParent()) {
        }
        boolean bl = b = parentNode != null && parentNode.getType() == 201110;
        if (b) {
            IXQEQueryNode q = node.getAncestorOfType(101006);
            if (q == null || !((V5Query)q).isDMR()) {
                return false;
            }
            MDXHierInfo hierInfo = ((V5MemberSummaryFunction)node).getSetHierarchyInfo(true);
            boolean bl2 = b = hierInfo.getNumProjectedHierarchies() == 1;
            if (b) {
                IHierarchy hier = hierInfo.getProjectedHierarchy(0);
                if (hier instanceof HierarchyWrapper) {
                    hier = ((HierarchyWrapper)hier).getWrappedHierarchy();
                }
                return hier instanceof MoserHierarchy;
            }
        }
        return b;
    }
}

