/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceSetExpression;

public class CoerceSetComparison
extends AbstractCoerceSetExpression {
    public CoerceSetComparison() {
        this.mName = "Coerce Set Expression for all arguments";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode rhsNode;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode lhsNode = node.getChild(0);
        if (!V5ExpressionCheck.isSetExpression(lhsNode)) {
            CoerceSetComparison.coerceToSetExpression(node.getChild(0), nodeFactory);
        }
        if (!V5ExpressionCheck.isSetExpression(rhsNode = node.getChild(1)) && !V5ExpressionCheck.isMemberExpression(rhsNode)) {
            CoerceSetComparison.coerceToSetExpression(rhsNode, nodeFactory);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5query;
        XQETrace trace = environment.getTrace();
        int subtype = ((V5ComparisonExpression)node).getSubType();
        if (subtype != 2 && subtype != 3) {
            this.traceNodeCondition(false, "The condition node is not '=' or '<>'", trace);
            return false;
        }
        if (node.getAncestorOfType(101008) == null) {
            this.traceNodeCondition(false, "The '='/'<>' condition node isn't in a detail filter", trace);
            return false;
        }
        if (node.getNumberChildren() > 2) {
            this.traceNodeCondition(false, "The '='/'<>' condition node is for a relational subquery", trace);
            return false;
        }
        if (node.getNumberChildren() != 2) {
            node.throwInternalError("2 child nodes expected.");
        }
        if ((v5query = (V5Query)node.getAncestorOfType(101006)) == null) {
            this.traceNodeCondition(false, "The '='/'<>' condition node isn't in a query", trace);
            return false;
        }
        if (v5query.isTabular()) {
            this.traceNodeCondition(false, "The '='/'<>' condition node isn't in an OLAP query", trace);
            return false;
        }
        IXQEQueryNode lhsNode = node.getChild(0);
        IXQEQueryNode rhsNode = node.getChild(1);
        if (V5ExpressionCheck.isValueExpression(lhsNode)) {
            this.traceNodeCondition(false, "The '='/'<>' condition node has a value expressions on the left hand side.", trace);
            return false;
        }
        if (V5ExpressionCheck.isValueExpression(rhsNode)) {
            this.traceNodeCondition(false, "The '='/'<>' condition node has a value expressions on the rigth hand side.", trace);
            return false;
        }
        boolean requiresCoercion = this.requiresSetCoercion(lhsNode);
        if (!requiresCoercion && !V5ExpressionCheck.isMemberExpression(rhsNode)) {
            requiresCoercion = this.requiresSetCoercion(rhsNode);
        }
        if (requiresCoercion) {
            this.traceNodeCondition(true, "One of the child nodes is not a set expression.", trace);
        } else {
            this.traceNodeCondition(false, "All the child nodes are set expressions.", trace);
        }
        return requiresCoercion;
    }
}

