/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceSetExpression;

public class CoerceSetExpressionArg2
extends AbstractCoerceSetExpression {
    public CoerceSetExpressionArg2() {
        this.mName = "Coerce Set Expression for second member";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201064, 201070, 201074, 201087, 201044, 201111, 201098, 201149};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CoerceSetExpressionArg2.coerceToSetExpression(node.getChild(1), nodeFactory);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() < 2) {
            this.traceNodeCondition(false, "There are less than two child nodes.", trace);
            return false;
        }
        boolean status = false;
        IXQEQueryNode child = node.getChild(1);
        if (node.getType() == 201098 && V5ExpressionCheck.isMemberExpression(child)) {
            this.traceNodeCondition(false, "Second child node of a rolevalue function is a member expression.", trace);
            return false;
        }
        if (V5ExpressionCheck.getExpressionType(child) == V5ExpressionTypeEnum.TUPLE) {
            V5ExpressionCheck.throwInvalidCoercionException(child, V5ExpressionTypeEnum.SET);
        }
        if (!(status = this.requiresSetCoercion(child))) {
            this.traceNodeCondition(status, "Second child node doesn't require set coercion.", trace);
        } else {
            this.traceNodeCondition(status, "Second child nodes is not a set expression.", trace);
        }
        return status;
    }
}

