/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceValueExpression;

public final class CoerceValueComparison
extends AbstractCoerceValueExpression {
    public CoerceValueComparison(int passNumber) {
        this.mName = "Coerce Value Comparisons";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (CoerceValueComparison.requiresValueCoercion(node.getChild(0))) {
            CoerceValueComparison.coerceToValueExpression(node.getChild(0), nodeFactory);
        }
        if (CoerceValueComparison.requiresValueCoercion(node.getChild(1))) {
            CoerceValueComparison.coerceToValueExpression(node.getChild(1), nodeFactory);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query;
        XQETrace trace = environment.getTrace();
        boolean status = true;
        if (node.getNumberChildren() != 2) {
            status = false;
            this.traceNodeCondition(status, "The comparison doesn't have two children.", trace);
        }
        if ((query = (V5Query)node.getAncestorOfType(101006)) != null && query.isTabular() && query.isRelStyle()) {
            this.traceNodeCondition(status, "The comparison is in a relational query.", trace);
            status = false;
        }
        if (status) {
            boolean valueComparison = true;
            V5ComparisonExpression comparisonNode = (V5ComparisonExpression)node;
            if (comparisonNode.getSubType() == 2 || comparisonNode.getSubType() == 3) {
                IXQEQueryNode lhsNode = node.getChild(0);
                V5ExpressionTypeEnum lhsExprType = V5ExpressionCheck.getExpressionType(lhsNode);
                IXQEQueryNode rhsNode = node.getChild(1);
                V5ExpressionTypeEnum rhsExprType = V5ExpressionCheck.getExpressionType(rhsNode);
                if (lhsExprType != V5ExpressionTypeEnum.VALUE && rhsExprType != V5ExpressionTypeEnum.VALUE) {
                    boolean bl = valueComparison = lhsExprType == V5ExpressionTypeEnum.MEMBER || lhsExprType == V5ExpressionTypeEnum.TUPLE;
                }
            }
            if (valueComparison) {
                boolean bl = status = CoerceValueComparison.requiresValueCoercion(node.getChild(0)) || CoerceValueComparison.requiresValueCoercion(node.getChild(1));
                if (status) {
                    this.traceNodeCondition(status, "One of the children is not a value expression.", trace);
                } else {
                    this.traceNodeCondition(status, "Both children are value expressions.", trace);
                }
            } else {
                status = false;
                this.traceNodeCondition(status, "The comparison is not comparing values.", trace);
            }
        }
        return status;
    }
}

