/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceValueExpression;

public final class CoerceValueExpressionArg2
extends AbstractCoerceValueExpression {
    public CoerceValueExpressionArg2(int passNumber) {
        this.mName = "Coerce Value Expressions - Second Argument";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[1];
        this.mTypes = new int[]{201071, 201077, 201081, 201083, 201091, 201093, 201105, 201019};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode valueExprNode = node.getChild(1);
        CoerceValueExpressionArg2.coerceToValueExpression(valueExprNode, nodeFactory);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        if (node.getNumberChildren() != 2) {
            status = false;
            this.traceNodeCondition(status, "The node doesn't have two children.", trace);
        }
        if (status && node.getType() == 201019 && node.getParent().getBooleanPropertyValue("isCaseCouldBeCollapsed") == Boolean.TRUE) {
            status = false;
            this.traceNodeCondition(status, "The case expression could have been collapsed.", trace);
        }
        if (status && !(status = CoerceValueExpressionArg2.requiresValueCoercion(node.getChild(1)))) {
            this.traceNodeCondition(status, "The second child node is a value expression.", trace);
        }
        if (status) {
            this.traceNodeCondition(status, "The second child node is not a value expression.", trace);
        }
        return status;
    }
}

