/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceValueExpression;

public final class CoerceValueExpressionIn
extends AbstractCoerceValueExpression {
    public CoerceValueExpressionIn() {
        this.mName = "Coerce Value Expressions - All Arguments";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[1];
        this.mTypes = new int[]{201011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (int idxChild = 0; idxChild < node.getNumberChildren(); ++idxChild) {
            IXQEQueryNode valueExprNode = node.getChild(idxChild);
            while (valueExprNode.getType() == 101003) {
                valueExprNode = valueExprNode.getChild(0);
            }
            if (!CoerceValueExpressionIn.requiresValueCoercion(valueExprNode)) continue;
            CoerceValueExpressionIn.coerceToValueExpression(valueExprNode, nodeFactory);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode leftOperant = node.getChild(0);
        while (leftOperant.getType() == 101003) {
            leftOperant = leftOperant.getChild(0);
        }
        boolean valueComparison = true;
        if (leftOperant.getType() == 201116) {
            if (!((V5BoundModelIdentifier)leftOperant).isMeasure()) {
                valueComparison = false;
            }
        } else if (leftOperant.getType() != 201085 || !((V5MemberFunction)leftOperant).isCalculatedMeasure()) {
            valueComparison = leftOperant.isOfCategory(201125);
        }
        if (valueComparison) {
            for (int idxChild = 0; idxChild < node.getNumberChildren() && !status; ++idxChild) {
                IXQEQueryNode aChild = node.getChild(idxChild);
                while (aChild.getType() == 101003) {
                    aChild = aChild.getChild(0);
                }
                status = CoerceValueExpressionIn.requiresValueCoercion(aChild);
            }
            if (status) {
                this.traceNodeCondition(status, "This is a value comparison and one of the child nodes is not a value expression.", trace);
            } else {
                this.traceNodeCondition(status, "This is a value comparison and all the child nodes are value expressions.", trace);
            }
        } else {
            this.traceNodeCondition(status, "This is not a value comparison.", trace);
        }
        return status;
    }
}

