/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyRowDecoration;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.normalization.RemoveV5ValueSetWithNoDataItemRefAndEmptyV5HeaderBodyFooter;

public final class CreateEmptyRowDecoForEmptyHeaderFooter
extends Transformation {
    public CreateEmptyRowDecoForEmptyHeaderFooter() {
        this.mName = "Create empty row decoration for empty V5 Group Header or Footer.";
        this.mPassNumbers = new int[]{0, 3};
        this.mTypes = new int[]{101053, 101052};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        rowset.setEmpty();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        OLAPEmptyRowDecoration emptyRowDeco = (OLAPEmptyRowDecoration)nodeFactory.createNode(601012);
        emptyRowDeco.setRSAPIRowsetProperty(rowset);
        emptyRowDeco.setSubType(node.getType());
        V5ValueSet parentValueSet = (V5ValueSet)node.getParent();
        parentValueSet.addEmptyRowDecorationProperty(emptyRowDeco);
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 0 && node.getPropertyValue("RSAPIEdgeRowset") != null && !RemoveV5ValueSetWithNoDataItemRefAndEmptyV5HeaderBodyFooter.nodeCondition(node.getParent(), null, environment)) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "The parent V5ValueSet is not empty, the target node is empty and has an RSAPI edge rowset.", trace);
        } else {
            this.traceNodeCondition(status, "Either The parent V5ValueSet is empty or the target node is not empty or the target node doesn't have an RSAPI edge rowset.", trace);
        }
        return status;
    }
}

