/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveEmptyEdge
extends Transformation {
    public RemoveEmptyEdge() {
        this.mName = "Remove V5 Edge node when the edge is empty.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 0) {
            status = true;
            this.traceNodeCondition(status, "The V5 edge is empty.", trace);
        } else {
            this.traceNodeCondition(status, "The V5 edge is not empty.", trace);
        }
        return status;
    }
}

