/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveEmptyV5HeaderBodyFooter
extends Transformation {
    public RemoveEmptyV5HeaderBodyFooter() {
        this.mName = "Remove empty V5 Group Header, Footer and Body from the V5 Query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101053, 101052, 101051, 101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!(node.getType() != 101050 && ((V5ValueSet)node.getParent()).isEmpty(false) || node.getNumberChildren() != 0 || (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset") != null)) {
            status = true;
            this.traceNodeCondition(status, "The parent V5ValueSet is not empty and the target node is empty and has no RSAPI rowset.", trace);
        }
        if (!status) {
            this.traceNodeCondition(status, "Either The parent V5ValueSet is empty or the target node is not empty or the target node has an RSAPI rowset.", trace);
        }
        return status;
    }
}

