/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5QueryTypeCheck;

public final class RemoveOnEmptyDetail
extends Transformation {
    public RemoveOnEmptyDetail() {
        this.mName = "Remove V5 Sort nodes when no Detail Expression.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101056};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (V5QueryTypeCheck.isRelationalQuery(node)) {
            this.traceNodeCondition(false, "This transformation is not applicable to a relational query.", trace);
            return false;
        }
        V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        if (valueSet == null) {
            this.traceNodeCondition(false, "There is no ancestor V5ValueSet node.", trace);
            return false;
        }
        if (valueSet.getPropertyValue("refDataItem") != null) {
            this.traceNodeCondition(false, "The ancestor V5ValueSet node has a refDataItem property.", trace);
            return false;
        }
        if (!valueSet.isEmpty(true)) {
            this.traceNodeCondition(false, "The ancestor V5ValueSet node has a non-empty group body.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The node does not have a detail expression and must be removed.", trace);
        return true;
    }
}

