/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;

public class OptimizeSectionedMasterDetailFilter
extends Transformation {
    public OptimizeSectionedMasterDetailFilter() {
        this.mName = "Optimized sectioned crosstab master-detail detail filters.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QueryNode lhsNode = (V5QueryNode)node.getChild(0);
        MDXLevelInfo contextLevel = new MDXLevelInfo();
        IHierarchy hierarchy = lhsNode.getHierarchyInfo().getProjectedHierarchy(0);
        contextLevel.addProjectedHierarchy(hierarchy.getDefaultMember().getLevel());
        ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
        MDXLevelInfo levelInfo = lhsNode.getHierarchyLevelInfo(contextLevel, fncs);
        List<ILevel> levels = levelInfo.getProjectedLevels(hierarchy);
        IMetadata metadata = null;
        metadata = levels.size() == 1 ? (IMetadata)levels.get(0) : hierarchy;
        V5BoundModelIdentifier boundMetadata = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        boundMetadata.setIdentifier(metadata.getUniqueName());
        boundMetadata.setMetadata(metadata);
        lhsNode.exchange(boundMetadata);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5ComparisonExpression comparison = (V5ComparisonExpression)node;
        if (comparison.getSubType() != 2) {
            this.traceQueryCondition(false, "The comparison is not '='.", trace);
            return false;
        }
        V5DetailFilter detailFilter = (V5DetailFilter)node.getAncestorOfType(101008);
        if (detailFilter == null) {
            this.traceQueryCondition(false, "The comparison is in a detail filter.", trace);
            return false;
        }
        if (detailFilter.getBooleanPropertyValue("masterDetailDFilter") == null) {
            this.traceQueryCondition(false, "The detail filter was not created for a master detail query.", trace);
            return false;
        }
        if (!V5ExpressionCheck.isSetExpression(node.getChild(0)) || detailFilter.getBooleanPropertyValue("masterDetailSectionedXtab") == Boolean.FALSE) {
            this.traceQueryCondition(false, "The LHS of the '=' is not a set expression in a sectioned xtab query.", trace);
            return false;
        }
        V5QueryNode lhsNode = (V5QueryNode)node.getChild(0);
        IHierarchy hierarchy = lhsNode.getHierarchyInfo().getProjectedHierarchy(0);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(hierarchy.getDimension().getCube());
        IDataProvider dataProvider = ProviderManager.getInstance().getProvider(ds.getType());
        if (!(dataProvider instanceof IOLAPDataProvider)) {
            this.traceQueryCondition(false, "Not OLAP provider.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The '=' is in a detail filter created by a master detail filter and the LHS is a set expression in a sectioned xtab query.", trace);
        return true;
    }
}

