/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.TabStreamWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.optimization.TransformMasterDetailQuery;

public class TransformMasterDetailQueryForRelationalCrosstab
extends Transformation {
    public TransformMasterDetailQueryForRelationalCrosstab() {
        this.mName = "Transform relational crosstab master-detail query to be executed all at once.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101059};
    }

    @Override
    public final void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TransformMasterDetailQuery.applyTransformation(node, environment, true);
        MasterDetailLink link = ((V5MasterDetailLink)node).getMDProviderLink();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5QueryResultDefinition detailQrd = querySet.getQRD(link.getDetailQrdName());
        detailQrd.setPropertyValue("mdQueryTransformed", Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query detailQuery;
        IDataSourceCapabilities capabilities;
        XQETrace trace = environment.getTrace();
        StringBuilder msg = new StringBuilder();
        if (!TransformMasterDetailQuery.checkPassNodeCondition(node, environment, msg, true)) {
            this.traceNodeCondition(false, msg.toString(), trace);
            return false;
        }
        String reqType = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName();
        if (reqType != null && reqType.equals("getParameters")) {
            this.traceNodeCondition(false, "no optimization for getParameters.", trace);
            return false;
        }
        MasterDetailLink link = ((V5MasterDetailLink)node).getMDProviderLink();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5QueryResultDefinition masterQrd = querySet.getQRD(link.getMasterQrdName());
        String detailQueryName = link.getDetailQueryName();
        IXQEQueryNode[] allLinks = masterQrd.getChildrenOfType(101059);
        if (allLinks.length > 1) {
            for (IXQEQueryNode aLink : allLinks) {
                if (aLink == node || !(link = ((V5MasterDetailLink)aLink).getMDProviderLink()).getDetailQueryName().equals(detailQueryName)) continue;
                this.traceNodeCondition(false, "optimization only for one master to one detail through one item.", trace);
                return false;
            }
        }
        if ((capabilities = DMRUtilities.getDatasourceCapabilities(detailQuery = querySet.getV5Query(detailQueryName), environment)) == null || !capabilities.isSupported("v5.master-detail.transform")) {
            this.traceNodeCondition(false, "Optimization is disabled for relational crosstab.", trace);
            return false;
        }
        V5QueryResultDefinition detailQrd = querySet.getQRD(link.getDetailQrdName());
        if (!TabStreamWrapper.needTabStream(detailQrd, detailQuery)) {
            this.traceNodeCondition(false, "optimization only for relational xtab.", trace);
            return false;
        }
        String masterRefDataItem = link.getMasterRefDataItem();
        if (this.masterItemUsedInDetailQRDAsGroupingItem(detailQrd, masterRefDataItem)) {
            this.traceNodeCondition(false, "Optimization should not require reporter mode transformation.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The master-detail optimization will be applied for relational crosstab.", trace);
        return true;
    }

    protected boolean masterItemUsedInDetailQRDAsGroupingItem(V5QueryResultDefinition detailQrd, String masterRefDataItem) {
        IXQEQueryNode[] valueSets;
        for (IXQEQueryNode valueSet : valueSets = detailQrd.getDescendantsOfType(101057, false)) {
            if (!((V5ValueSet)valueSet).getRefDataItemProperty().equals(masterRefDataItem)) continue;
            return true;
        }
        return false;
    }
}

