/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;

public final class CleanScopeProperty
extends Transformation {
    public CleanScopeProperty() {
        this.mName = "Remove scope property.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{101055, 101049, 101057, 101003, 201039, 101009};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Object prop = node.getPropertyValue("scope");
        if (prop != null) {
            node.removeProperty("scope");
        }
        if ((prop = node.getPropertyValue("relationalCrossTab")) != null) {
            node.removeProperty("relationalCrossTab");
            this.setSimpleQRDWithoutStorage(environment, node);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Object flag = node.getPropertyValue("scope");
        if (flag == null) {
            flag = node.getPropertyValue("relationalCrossTab");
        }
        if (flag != null) {
            this.traceNodeCondition(true, "need to remove the property.", trace);
            return true;
        }
        this.traceNodeCondition(false, "no property.", trace);
        return false;
    }

    protected void setSimpleQRDWithoutStorage(PlanningEnvironment environment, IXQEQueryNode node) {
        String suppressQueryHint;
        if (node.getType() != 101055) {
            return;
        }
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query query = v5QRD.getV5Query();
        Boolean nullSupressFlag = null;
        IXQEQueryNode[] edges = v5QRD.getChildrenOfType(101049);
        V5Selection sel = query.getV5Selection();
        IXQEQueryNode suppressEdge = null;
        for (IXQEQueryNode aEdge : edges) {
            Boolean f = (Boolean)aEdge.getPropertyValue("suppressNullsForSiblings");
            if (f == null) continue;
            aEdge.removeProperty("suppressNullsForSiblings");
            if (nullSupressFlag == null) {
                nullSupressFlag = f;
                suppressEdge = aEdge;
                continue;
            }
            nullSupressFlag = Boolean.FALSE;
        }
        if (nullSupressFlag == Boolean.TRUE) {
            for (IXQEQueryNode aEdge : edges) {
                if (aEdge == suppressEdge || !this.hasPotentialFiller(aEdge, sel)) continue;
                nullSupressFlag = Boolean.FALSE;
                break;
            }
        }
        if ((suppressQueryHint = (String)query.getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName())) == null || !"nulls".equalsIgnoreCase(suppressQueryHint) && !"none".equalsIgnoreCase(suppressQueryHint)) {
            if (nullSupressFlag == Boolean.TRUE && this.measuredefined(query)) {
                query.setPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName(), "nulls");
            } else {
                query.setPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName(), "none");
            }
        } else if ("nulls".equalsIgnoreCase(suppressQueryHint) && (!this.measuredefined(query) || nullSupressFlag != Boolean.TRUE)) {
            query.setPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName(), "none");
        }
        if (query.getV5DetailFilters().length > 0 || query.getV5SummaryFilters().length > 0) {
            this.enableCacheForReRun(environment, query);
            return;
        }
        for (IXQEQueryNode edge : edges) {
            if (!this.hasSiblingsOrComplexExpr(edge, sel)) continue;
            this.enableCacheForReRun(environment, query);
            return;
        }
        V5Source src = query.getV5Source();
        CubeWrapper theCubeWrapper = (CubeWrapper)src.getPropertyValue("needTabularStream");
        theCubeWrapper.setDirectReturnCellValues(true);
    }

    private void enableCacheForReRun(PlanningEnvironment environment, V5Query query) {
        IXQEQueryNode[] objs = query.getDescendantsOfType(201116, false);
        boolean hasExternalMeasure = false;
        for (IXQEQueryNode o : objs) {
            IMetadata m;
            if (!((V5BoundModelIdentifier)o).isMeasure() || (m = ((V5BoundModelIdentifier)o).getMetadata()).getProperty("externalRollUpScopes") == null) continue;
            hasExternalMeasure = true;
            break;
        }
        if (!hasExternalMeasure) {
            return;
        }
        TabStreamUtil.WrapCommonObjects e = TabStreamUtil.createCommonObjectsWrapper(environment, query);
        e.mTabQuery.getGovernors().setExecutionOptimization(Governors.ExecutionOptimization.FIRSTROW.toString());
        RSAPIDataset rsapiDataset = (RSAPIDataset)e.mTabQuery.getFirstChildByType(401005);
        rsapiDataset.setOptimizeForAllRows(false);
    }

    protected boolean hasPotentialFiller(IXQEQueryNode node, V5Selection sel) {
        IXQEQueryNode[] children = node.getChildrenOfType(101050);
        if (children.length > 1) {
            ArrayList<IHierarchy> projHierarchies = new ArrayList<IHierarchy>();
            IXQEQueryNode[] iXQEQueryNodeArray = children;
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; i < n; ++i) {
                IXQEQueryNode[] metas;
                IXQEQueryNode child = iXQEQueryNodeArray[i];
                V5ValueSet valueSet = (V5ValueSet)child.getFirstChildByType(101057);
                String refDataItem = valueSet.getRefDataItemProperty();
                V5DataItem v5DataItem = sel.getDataItemByRefName(refDataItem);
                for (IXQEQueryNode meta : metas = v5DataItem.getDescendantsOfType(201116, false)) {
                    V5BoundModelIdentifier id = (V5BoundModelIdentifier)meta;
                    IHierarchy h = id.getHierarchy();
                    if (h == null || projHierarchies.contains(h)) continue;
                    projHierarchies.add(h);
                }
            }
            if (projHierarchies.size() > 1) {
                for (int i = 0; i < projHierarchies.size() - 1; ++i) {
                    if (((IHierarchy)projHierarchies.get(i)).getDimension().isMeasuresDimension() || ((IHierarchy)projHierarchies.get(i)).getLevelCount() <= 2) continue;
                    return true;
                }
            }
        }
        for (IXQEQueryNode aChild : children) {
            if (!this.hasPotentialFiller(aChild, sel)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSiblingsOrComplexExpr(IXQEQueryNode node, V5Selection sel) {
        IXQEQueryNode[] children = node.getChildrenOfType(101050);
        if (children.length > 1) {
            for (IXQEQueryNode child : children) {
                IXQEQueryNode[] childrenOfChild = child.getChildrenOfType(101050);
                if (childrenOfChild.length > 0) {
                    return true;
                }
                V5ValueSet valueSet = (V5ValueSet)child.getFirstChildByType(101057);
                String refDataItem = valueSet.getRefDataItemProperty();
                V5DataItem v5DataItem = sel.getDataItemByRefName(refDataItem);
                IXQEQueryNode c = v5DataItem.getChild(0);
                if (c.getType() != 201116) {
                    return true;
                }
                V5BoundModelIdentifier id = (V5BoundModelIdentifier)c;
                if (id.isMeasure()) continue;
                return true;
            }
            return false;
        }
        if (node.getType() == 101050) {
            V5ValueSet valueSet = (V5ValueSet)node.getFirstChildByType(101057);
            String refDataItem = valueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = sel.getDataItemByRefName(refDataItem);
            IXQEQueryNode c = v5DataItem.getChild(0);
            if (c.getType() == 201086) {
                c = c.getChild(0);
            }
            if (c.getType() != 201116) {
                return true;
            }
            V5BoundModelIdentifier id = (V5BoundModelIdentifier)c;
            if (id.isMeasure()) {
                return false;
            }
            IMetadata metadataObj = id.getMetadata();
            if (metadataObj.getObjectType() != MetadataType.LEVEL) {
                return true;
            }
        }
        for (IXQEQueryNode aChild : children) {
            if (!this.hasSiblingsOrComplexExpr(aChild, sel)) continue;
            return true;
        }
        return false;
    }

    protected boolean measuredefined(V5Query query) {
        IXQEQueryNode[] objs;
        for (IXQEQueryNode o : objs = query.getDescendantsOfType(201116, false)) {
            if (!((V5BoundModelIdentifier)o).isMeasure()) continue;
            return true;
        }
        return false;
    }
}

