/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.unwinding.UnwindV5BoundModelId;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathSelector;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class DetectBridgeInRelationalXtab
extends Transformation {
    public DetectBridgeInRelationalXtab() {
        this.mName = "Detect Bridge in Relational XTab";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101055};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IMetadata> querySubjects;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        MetadataConnectionContext metadataConnectionContext = null;
        if (environment.isMultiModelForQueryEnabled() && v5Query != null) {
            metadataConnectionContext = environment.pushMetadataConnectionContext(v5Query.getMetadataPath());
        }
        if (DetectBridgeInRelationalXtab.queryUsesBridge(querySubjects = DetectBridgeInRelationalXtab.getQuerySubjectsInvolved(v5Query, environment), v5Query.getGovernors(), environment)) {
            v5Query.setPropertyValue("queryUsesBridge", true);
            return;
        }
        if (metadataConnectionContext != null) {
            metadataConnectionContext.close();
        }
        v5Query.setPropertyValue("queryUsesBridge", false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getPropertyValue("mdQueryTransformed") != null) {
            this.traceNodeCondition(false, "Plan combined QRD.", trace);
            return false;
        }
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        if (v5QRD.isMixedDMRRelational() == Boolean.TRUE) {
            this.traceNodeCondition(false, "handled as mixed DMR and relational.", trace);
            return false;
        }
        V5Query v5Query = v5QRD.getV5Query();
        if (v5Query.getPropertyValue("queryUsesBridge") != null) {
            this.traceNodeCondition(false, "Already detected if this uses a Bridge.", trace);
            return false;
        }
        V5Source v5Source = v5Query.getV5Source();
        if (!v5QRD.isList() && v5Source != null && Boolean.TRUE == v5Source.getPropertyValue("needTabularStream") && (v5Query.isTabular() || v5Query.isRelStyle())) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "Detect if this relational crosstab uses a bridge.", trace);
        } else {
            this.traceNodeCondition(status, "This is not a relational crosstab.", trace);
        }
        return status;
    }

    public static boolean queryUsesBridge(List<IMetadata> querySubjects, Governors governors, PlanningEnvironment environment) {
        if (querySubjects.size() < 2) {
            return false;
        }
        for (IMetadata m : querySubjects) {
            if (!(m instanceof IQuerySubject) || !SummaryQuerySubjectUtilities.isDynamicSQS((IQuerySubject)m)) continue;
            return false;
        }
        RQPJoinPathFinder joinPathFinder = new RQPJoinPathFinder(querySubjects, governors, environment);
        List<List<IMetadata>> allJoinPaths = joinPathFinder.getAllJoinPaths();
        List<IMetadata> joinPath = null;
        if (allJoinPaths != null) {
            if (allJoinPaths.size() == 1) {
                joinPath = allJoinPaths.get(0);
            } else {
                RQPJoinPathSelector joinSelector = new RQPJoinPathSelector();
                joinPath = joinSelector.selectBestJoinPath(allJoinPaths);
            }
        }
        if (joinPath == null) {
            return false;
        }
        for (IMetadata q : joinPath) {
            IRelationship relationship = (IRelationship)q;
            IXQEQueryNode expression = RQPUtilities.getV5BoundRelationshipExpression(relationship, environment);
            if (expression == null || !DetectBridgeInRelationalXtab.usesBridgeQS(expression, environment)) continue;
            return true;
        }
        return false;
    }

    public static List<IMetadata> getQuerySubjectsInvolved(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] nodesToProcess;
        ArrayList<IMetadata> list = new ArrayList<IMetadata>();
        IXQEQueryNode nodeClone = environment.getNodeFactory().deepCopyNode(node);
        int[] pn = new int[]{1};
        UnwindV5BoundModelId transformation = new UnwindV5BoundModelId(pn);
        for (IXQEQueryNode v5Node : nodesToProcess = nodeClone.getDescendantsOfType(201116, true)) {
            if (!transformation.passesQueryCondition(v5Node, environment)) continue;
            ((Transformation)transformation).apply(v5Node, environment);
        }
        for (IXQEQueryNode v5Node : nodesToProcess = nodeClone.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier bId = (V5BoundModelIdentifier)v5Node;
            IQuerySubject qs = bId.getQuerySubject();
            if (qs == null || list.contains(qs)) continue;
            list.add(qs);
        }
        return list;
    }

    private static boolean usesBridgeQS(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] identifiers;
        for (IXQEQueryNode identifier : identifiers = node.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier bId = (V5BoundModelIdentifier)identifier;
            IQuerySubject qs = bId.getQuerySubject();
            if (qs == null || !qs.getQuerySubjectUsage().equals((Object)IQuerySubject.QuerySubjectUsageEnum.BRIDGE)) continue;
            return true;
        }
        return false;
    }
}

