/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamExternalAggrUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;

public final class GenerateSingleTabularStreamRelationalXtab
extends Transformation {
    public GenerateSingleTabularStreamRelationalXtab() {
        this.mName = "Generate single list query for relational crosstab.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        this.createEmptyListQuery(environment, node);
    }

    protected void createEmptyListQuery(PlanningEnvironment environment, IXQEQueryNode node) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5QuerySet v5QuerySet = (V5QuerySet)v5QRD.getAncestorOfType(101002);
        Boolean bNoDataMode = v5QuerySet.getBooleanPropertyValue(V5QuerySet.RequestHint.NO_DATA_MODE.getPropertyName());
        V5Query v5Query = v5QRD.getV5Query();
        v5Query.setPropertyValue("relationalCrossTab", true);
        RSAPIDataset rsapiDataset = (RSAPIDataset)v5QRD.getAncestorOfType(401005);
        rsapiDataset.setForXtabRelational(true);
        RSAPIDataset tabDataset = (RSAPIDataset)nodeFactory.createNode(401005);
        tabDataset.setReturnDataItemNameInPartialDataset(environment);
        String subName = rsapiDataset.getName() + "_subTabularResult";
        Governors tabGovernors = null;
        if (v5Query.getGovernors() != null) {
            tabGovernors = v5Query.getGovernors().copy();
            tabGovernors.setExecutionOptimization(Governors.ExecutionOptimization.ALLROWS.toString());
            if (tabGovernors.getSuppressDuplicateMeasureValues() == Governors.SuppressDuplicateMeasureValues.SERVERDETERMINED) {
                if (!TabStreamExternalAggrUtil.supportExternalAggrAvoidDoubleCounting(environment.getMetadataConnection())) {
                    tabGovernors.setSuppressDuplicateMeasureValues(Governors.SuppressDuplicateMeasureValues.ENABLE.toString());
                } else {
                    v5Query.setPropertyValue("enableExtAggrAvoidSummaryDoubleCounting", Boolean.TRUE);
                }
            }
        }
        tabDataset.setName(subName);
        tabDataset.setRefQueryName(subName);
        tabDataset.setGovernors(tabGovernors);
        tabDataset.setOptimizeForAllRows(true);
        tabDataset.setUseSAPMUNAsBusinessKey(rsapiDataset.isUseSAPMUNAsBusinessKey());
        V5QueryResultDefinition tabQRD = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        tabQRD.setPropertyValue("wrapTo", "none");
        tabDataset.addChild(tabQRD);
        tabQRD.setPropertyValue("name", subName);
        tabQRD.setPropertyValue("refQuery", subName);
        if (reqEnv.getMaxSeverityLevel() >= 2) {
            tabDataset.setQueryFeedbacks(v5QRD.getQueryFeedbacks());
        }
        V5Query tabQuery = (V5Query)nodeFactory.createNode(101006);
        tabQuery.setPropertyValue("name", subName);
        tabQuery.setPropertyValue("rootQueryName", v5Query.getV5QueryName());
        tabQuery.setPropertyValue("isTabular", Boolean.TRUE);
        tabQuery.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.XTABREL.getName());
        if (v5Query.getMetadataPath() != null) {
            tabQuery.setMetadataPath(v5Query.getMetadataPath());
        }
        tabQuery.setGovernors(tabGovernors);
        if (v5Query.getGovernors() != null && v5Query.getGovernors().getExecutionOptimization() == Governors.ExecutionOptimization.ALLROWS) {
            v5Query.setPropertyValue(Governors.ExecutionOptimization.ALLROWS.toString(), Boolean.TRUE);
        }
        V5Source tabSource = (V5Source)nodeFactory.deepCopyNode(v5Query.getV5Source());
        tabSource.removeProperty("needTabularStream");
        tabQuery.addChild(tabSource);
        V5Selection tabSelection = (V5Selection)nodeFactory.createNode(101009);
        V5Selection selection = v5Query.getV5Selection();
        boolean bAutoSummary = selection.getAutoSummary();
        tabSelection.setPropertyValue("originalAutoSummary", bAutoSummary);
        if (Boolean.TRUE == selection.getPropertyValue("keepDefinedAutoSummary")) {
            tabSelection.setAutoSummary(bAutoSummary);
        }
        tabQuery.addChild(tabSelection);
        IXQEQueryNode tabEdge = nodeFactory.createNode(101049);
        ((V5Edge)tabEdge).setEdgeID(0);
        tabEdge.setPropertyValue("name", "1");
        tabQRD.addChild(tabEdge);
        IXQEQueryNode tabEdgeGroup = nodeFactory.createNode(101050);
        tabEdge.addChild(tabEdgeGroup);
        V5ValueSet tabValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        tabValueSet.setPropertyValue("name", "3");
        tabValueSet.setIsReportDetail(Boolean.TRUE);
        tabEdgeGroup.addChild(tabValueSet);
        IXQEQueryNode tabGroupBody = nodeFactory.createNode(101051);
        tabGroupBody.setPropertyValue("name", "3_gb");
        tabGroupBody.setPropertyValue("RSAPIInfoCollected", Boolean.TRUE);
        tabValueSet.addChild(tabGroupBody);
        RSAPIEdge tabRsapiEdge = new RSAPIEdge();
        tabRsapiEdge.setName((String)tabEdge.getPropertyValue("name"));
        int edgeId = ((V5Edge)tabEdge).getEdgeID();
        tabRsapiEdge.setOrdinal(edgeId);
        tabEdge.setPropertyValue("RSAPIEdge", tabRsapiEdge);
        tabRsapiEdge.setDataset(tabDataset);
        tabDataset.addEdge(tabRsapiEdge);
        RSAPIEdgeRowset tabRowset = new RSAPIEdgeRowset();
        if (null != bNoDataMode) {
            tabRowset.setNoDataMode(bNoDataMode);
        }
        tabValueSet.setRSAPIEdgeRowset(tabRowset);
        tabRowset.setName((String)tabValueSet.getPropertyValue("name"));
        tabRowset.setRowsetId(0);
        tabRowset.setEdge(tabRsapiEdge);
        tabRsapiEdge.addRowset(tabRowset);
        tabRsapiEdge.setRootRowset(tabRowset);
        v5QuerySet.addChild(tabQuery);
        tabQuery.addChild(tabDataset);
        node.setPropertyValue("tabstreamDefinition", subName);
        if (GenerateSingleTabularStreamRelationalXtab.checkSiblingEdgeGroups(v5QRD, v5Query)) {
            node.setPropertyValue("scope", new ArrayList());
        }
        node.setPropertyValue("relationalCrossTab", Boolean.TRUE);
        rsapiDataset.setAllowNonNumericCellValue(Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object tabName;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        if (v5QRD.getPropertyValue("mdQueryTransformed") != null) {
            this.traceNodeCondition(false, "Plan combined QRD.", trace);
            return false;
        }
        Boolean b = v5QRD.isMixedDMRRelational();
        if (b != null && b == Boolean.TRUE) {
            this.traceNodeCondition(false, "handled as mixed DMR and relational.", trace);
            return false;
        }
        V5Query v5Query = v5QRD.getV5Query();
        if (v5Query.getPropertyValue("relationalCrossTab") != null) {
            this.traceNodeCondition(false, "Already generate a relational stream for this query.", trace);
            return false;
        }
        V5Source v5Source = v5Query.getV5Source();
        if (!v5QRD.isList() && v5Source != null && Boolean.TRUE == v5Source.getPropertyValue("needTabularStream") && (v5Query.isTabular() || v5Query.isRelStyle()) && (tabName = v5QRD.getPropertyValue("tabstreamDefinition")) == null) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "need to generate single tabular query for relatioanl crosstab.", trace);
        } else {
            this.traceNodeCondition(status, "don't generate single tabular query for relatioanl crosstab.", trace);
        }
        return status;
    }

    public static boolean checkSiblingEdgeGroups(V5QueryResultDefinition v5QRD, V5Query v5Query) {
        IXQEQueryNode[] edges;
        IXQEQueryNode[] edgeGroups;
        V5Selection selection = v5Query.getV5Selection();
        for (IXQEQueryNode group : edgeGroups = v5QRD.getDescendantsOfType(101050, false)) {
            IXQEQueryNode[] children = group.getChildrenOfType(101050);
            if (children.length <= 1 || !GenerateSingleTabularStreamRelationalXtab.checkSiblings(group, children, selection)) continue;
            return true;
        }
        for (IXQEQueryNode edge : edges = v5QRD.getDescendantsOfType(101049, false)) {
            IXQEQueryNode[] children = edge.getChildrenOfType(101050);
            if (children.length <= 1 || !GenerateSingleTabularStreamRelationalXtab.checkSiblings(null, children, selection)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkSiblings(IXQEQueryNode group, IXQEQueryNode[] children, V5Selection selection) {
        String firstNonFactItem = null;
        String factItem = null;
        String firstNonFactItemParent = null;
        String parentDataItem = null;
        if (group != null) {
            V5ValueSet valueSet = (V5ValueSet)group.getFirstChildByType(101057);
            parentDataItem = valueSet.getRefDataItemProperty();
        }
        for (IXQEQueryNode child : children) {
            V5ValueSet valueSet = (V5ValueSet)child.getFirstChildByType(101057);
            String refDataItem = valueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = selection.getDataItemByRefName(refDataItem);
            if (v5DataItem.isOLAPConstruct()) {
                if (!GenerateSingleTabularStreamRelationalXtab.hasNonFactDescendants(child, selection)) continue;
                return true;
            }
            if (TabStreamUtil.isFactItem(v5DataItem)) {
                if (GenerateSingleTabularStreamRelationalXtab.hasNonFactDescendants(child, selection)) {
                    return true;
                }
                factItem = refDataItem;
                continue;
            }
            if (parentDataItem != null && parentDataItem.equals(refDataItem)) {
                if (GenerateSingleTabularStreamRelationalXtab.hasNonFactDescendants(child, selection)) {
                    return true;
                }
                firstNonFactItemParent = refDataItem;
                continue;
            }
            if (firstNonFactItem == null) {
                firstNonFactItem = refDataItem;
                continue;
            }
            return true;
        }
        return firstNonFactItem != null && factItem != null || firstNonFactItem != null && firstNonFactItemParent != null;
    }

    protected static boolean hasNonFactDescendants(IXQEQueryNode edgeGroup, V5Selection selection) {
        IXQEQueryNode[] edgeGroups;
        for (IXQEQueryNode group : edgeGroups = edgeGroup.getDescendantsOfType(101050, false)) {
            V5ValueSet valueSet = (V5ValueSet)group.getFirstChildByType(101057);
            String refDataItem = valueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = selection.getDataItemByRefName(refDataItem);
            if (v5DataItem.isOLAPConstruct() || TabStreamUtil.isFactItem(v5DataItem)) continue;
            return true;
        }
        return false;
    }
}

