/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public final class GetScopeForRelationalCrosstab
extends Transformation {
    public GetScopeForRelationalCrosstab() {
        this.mName = "Get scope for Relational CrossTab.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] edges;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        V5Selection selection = v5Query.getV5Selection();
        int reportMeasureEdgeId = -1;
        IXQEQueryNode reportMeasureEdge = null;
        String reportMeasureValueSetName = null;
        HashSet<String> measureValueSetNames = new HashSet<String>();
        for (IXQEQueryNode edge : edges = node.getChildrenOfType(101049)) {
            V5ValueSet valueSet;
            String refItem;
            V5DataItem item;
            IXQEQueryNode[] v5Grps = edge.getDescendantsOfType(101050, false);
            if (v5Grps.length == 0) continue;
            if (v5Grps.length == 1 && !(item = selection.getDataItemByRefName(refItem = (valueSet = (V5ValueSet)v5Grps[0].getFirstChildByType(101057)).getRefDataItemProperty())).isOLAPConstruct() && TabStreamUtil.isFactItem(item) && (reportMeasureEdgeId == -1 || reportMeasureEdgeId < ((V5Edge)edge).getEdgeID())) {
                reportMeasureEdgeId = ((V5Edge)edge).getEdgeID();
                reportMeasureEdge = edge;
                reportMeasureValueSetName = valueSet.getNameProperty();
            }
            ArrayList<HashSet<String>> edgeScope = new ArrayList<HashSet<String>>();
            HashMap<IXQEQueryNode, IXQEQueryNode> aggregateMap = this.getAggregateAssociation(v5Grps, selection, measureValueSetNames, environment);
            int i = 0;
            for (i = 0; i < v5Grps.length; ++i) {
                IXQEQueryNode v5GrpTmp = v5Grps[i].getFirstChildByType(101050);
                if (v5GrpTmp == null) continue;
                v5Grps[i] = null;
            }
            HashMap<IXQEQueryNode, IXQEQueryNode> measureMap = this.getMeasureAssociation(v5Grps, selection, aggregateMap, measureValueSetNames);
            ArrayList flatList = new ArrayList();
            for (IXQEQueryNode v5Grp : v5Grps) {
                if (v5Grp == null) continue;
                ArrayList<IXQEQueryNode> list = new ArrayList<IXQEQueryNode>();
                list.add(v5Grp);
                for (IXQEQueryNode parent = v5Grp.getParent(); parent != null && parent.getType() != 101049; parent = parent.getParent()) {
                    if (parent.getType() != 101050) continue;
                    list.add(parent);
                }
                Collections.reverse(list);
                flatList.add(list);
            }
            for (ArrayList arrayList : flatList) {
                HashSet<String> s = this.createAEdgeScope(arrayList, selection, aggregateMap, measureMap);
                if (s == null) continue;
                edgeScope.add(s);
            }
            edge.setPropertyValue("scope", edgeScope);
        }
        int pos = 0;
        LinkedList<HashSet<String>> stack = new LinkedList<HashSet<String>>();
        this.crossjoinEdges(edges, pos, stack, reportMeasureEdge);
        if (reportMeasureValueSetName != null) {
            HashSet<String> tmp = new HashSet<String>();
            ArrayList<HashSet<String>> scope = TabStreamUtil.getScopeProperty(v5QRD);
            for (HashSet<String> s : scope) {
                tmp.clear();
                tmp.addAll(s);
                tmp.retainAll(measureValueSetNames);
                if (!tmp.isEmpty()) continue;
                s.add(reportMeasureValueSetName);
            }
        }
    }

    protected HashMap<IXQEQueryNode, IXQEQueryNode> getAggregateAssociation(IXQEQueryNode[] v5Grps, V5Selection selection, HashSet<String> measureValueSetNames, PlanningEnvironment environment) {
        HashMap<IXQEQueryNode, IXQEQueryNode> aggregateMap = new HashMap<IXQEQueryNode, IXQEQueryNode>();
        for (IXQEQueryNode aGrp : v5Grps) {
            V5ValueSet valueSet = (V5ValueSet)aGrp.getFirstChildByType(101057);
            String refItem = valueSet.getRefDataItemProperty();
            V5DataItem item = selection.getDataItemByRefName(refItem);
            if (!item.isOLAPConstruct()) {
                if (!TabStreamUtil.isFactItem(item)) continue;
                measureValueSetNames.add(valueSet.getNameProperty());
                continue;
            }
            IXQEQueryNode detailEdgeGroup = TabStreamUtil.getReportSummaryDetailEdgeGroup(valueSet, item, null);
            if (detailEdgeGroup != null || !TabStreamUtil.needDecompose(environment, item)) {
                aggregateMap.put(aGrp, detailEdgeGroup);
                continue;
            }
            measureValueSetNames.add(valueSet.getNameProperty());
        }
        return aggregateMap;
    }

    protected HashMap<IXQEQueryNode, IXQEQueryNode> getMeasureAssociation(IXQEQueryNode[] v5Grps, V5Selection selection, HashMap<IXQEQueryNode, IXQEQueryNode> aggregateMap, HashSet<String> measureValueSetNames) {
        HashMap<IXQEQueryNode, IXQEQueryNode> measureMap = new HashMap<IXQEQueryNode, IXQEQueryNode>();
        block0: for (IXQEQueryNode aGrp : v5Grps) {
            IXQEQueryNode[] siblings;
            V5ValueSet valueSet;
            String vsName;
            if (aGrp == null || aggregateMap.containsKey(aGrp) || !measureValueSetNames.contains(vsName = (valueSet = (V5ValueSet)aGrp.getFirstChildByType(101057)).getNameProperty()) || aGrp.getDescendantsOfType(101050, false).length > 0) continue;
            for (IXQEQueryNode sibling : siblings = aGrp.getParent().getChildrenOfTypeOrdered(101050)) {
                if (sibling == aGrp) break;
                V5ValueSet vSet = (V5ValueSet)sibling.getFirstChildByType(101057);
                vsName = vSet.getNameProperty();
                if (!measureValueSetNames.contains(vsName) || sibling.getDescendantsOfType(101050, false).length != 0) continue;
                measureMap.put(aGrp, sibling);
                continue block0;
            }
        }
        return measureMap;
    }

    protected HashSet<String> createAEdgeScope(ArrayList<IXQEQueryNode> v5Groups, V5Selection selection, HashMap<IXQEQueryNode, IXQEQueryNode> aggregateMap, HashMap<IXQEQueryNode, IXQEQueryNode> measureMap) {
        HashSet<String> scope = new HashSet<String>();
        for (IXQEQueryNode aGrp : v5Groups) {
            if (aggregateMap.containsKey(aGrp) || measureMap.containsKey(aGrp)) {
                return null;
            }
            V5ValueSet vSet = (V5ValueSet)aGrp.getFirstChildByType(101057);
            String vname = vSet.getNameProperty();
            scope.add(vname);
            if (measureMap.containsValue(aGrp)) {
                for (Map.Entry<IXQEQueryNode, IXQEQueryNode> e : measureMap.entrySet()) {
                    if (e.getValue() != aGrp) continue;
                    IXQEQueryNode aMeasureGrp = e.getKey();
                    vSet = (V5ValueSet)aMeasureGrp.getFirstChildByType(101057);
                    vname = vSet.getNameProperty();
                    scope.add(vname);
                }
            }
            if (!aggregateMap.containsValue(aGrp)) continue;
            for (Map.Entry<IXQEQueryNode, IXQEQueryNode> e : aggregateMap.entrySet()) {
                IXQEQueryNode[] childEdgeGroups;
                if (e.getValue() != aGrp) continue;
                IXQEQueryNode aSummaryGrp = e.getKey();
                for (IXQEQueryNode child : childEdgeGroups = aSummaryGrp.getChildrenOfType(101050)) {
                    vSet = (V5ValueSet)child.getFirstChildByType(101057);
                    vname = vSet.getNameProperty();
                    scope.add(vname);
                }
            }
        }
        return scope;
    }

    protected void crossjoinEdges(IXQEQueryNode[] edges, int pos, LinkedList<HashSet<String>> stack, IXQEQueryNode reportMeasureEdge) {
        IXQEQueryNode edge = edges[pos];
        ArrayList<HashSet<String>> edgeScope = TabStreamUtil.getScopeProperty(edge);
        if (pos == edges.length - 1) {
            if (edgeScope == null || edge == reportMeasureEdge) {
                this.addScope(edge.getParent(), stack);
            } else {
                for (HashSet<String> s : edgeScope) {
                    stack.addLast(s);
                    this.addScope(edge.getParent(), stack);
                    stack.removeLast();
                }
            }
        } else if (edgeScope == null || edge == reportMeasureEdge) {
            this.crossjoinEdges(edges, pos + 1, stack, reportMeasureEdge);
        } else {
            for (HashSet<String> s : edgeScope) {
                stack.addLast(s);
                this.crossjoinEdges(edges, pos + 1, stack, reportMeasureEdge);
                stack.removeLast();
            }
        }
    }

    protected void addScope(IXQEQueryNode qrd, LinkedList<HashSet<String>> stack) {
        ArrayList<HashSet<String>> scope = TabStreamUtil.getScopeProperty(qrd);
        HashSet s = new HashSet();
        for (HashSet hashSet : stack) {
            s.addAll(hashSet);
        }
        scope.add(s);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        ArrayList<HashSet<String>> scope = TabStreamUtil.getScopeProperty(node);
        boolean bl = status = scope != null && scope.isEmpty();
        if (status) {
            this.traceNodeCondition(status, "need to get scope.", trace);
        } else {
            this.traceNodeCondition(status, "scope is not required or has been done.", trace);
        }
        return status;
    }
}

