/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserSortItem;
import java.util.HashSet;
import java.util.Set;

public final class InjectFacetSortDataItem
extends Transformation {
    public static final String INJECT_FACET_SORT = "injectFacetSort";

    public InjectFacetSortDataItem() {
        this.mName = "Inject Facet Sort V5DataItem.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(INJECT_FACET_SORT, Boolean.TRUE);
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItem = valueSet.getRefDataItemProperty();
        V5Query query = v5QRD.getV5Query();
        V5Selection v5Selection = query.getV5Selection();
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItem);
        IXQEQueryNode expression = v5DataItem.getChild(0);
        IMetadata exprMd = ((V5BoundModelIdentifier)expression).getMetadata();
        MoserQueryItem qi = (MoserQueryItem)exprMd;
        IFacet facet = qi.getFacet();
        ISortItem[] sortItems = facet.getSortItems();
        IXQEQueryNode[] v5sorts = valueSet.getChildrenOfType(101056);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String extraDataItemNamePrefix = "valueset_" + valueSet.getNameProperty() + "_extraSortDataItem_";
        String explictSortDirection = null;
        String explicitNullPlace = null;
        if (v5sorts.length == 1) {
            V5SortItem v5Sort = (V5SortItem)v5sorts[0];
            explictSortDirection = v5Sort.getSortOrder();
            explicitNullPlace = v5Sort.getNullPlace();
            v5Sort.detach();
        }
        int n = 1;
        for (ISortItem si : sortItems) {
            IMetadata sortMetadata;
            MoserSortItem sortItem = (MoserSortItem)si;
            String ref = sortItem.getRefObject();
            if (ref == null || (sortMetadata = this.bindSortReference(environment, ref, qi.getQuerySubject())) == null) continue;
            String sortDirection = this.getSortDirection(sortItem, explictSortDirection);
            String nullPlacement = explicitNullPlace;
            if (nullPlacement == null) {
                ISortItem.NullPlacementType nullPlace = sortItem.getNullPlacement();
                if (nullPlace == null || nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
                    nullPlacement = "last";
                } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
                    nullPlacement = "first";
                }
            }
            String newDataItem = extraDataItemNamePrefix + n++;
            IXQEQueryNode sortItemNode = nodeFactory.createNode(101056);
            sortItemNode.setPropertyValue("refDataItem", newDataItem);
            sortItemNode.setPropertyValue("sortOrder", sortDirection);
            if (nullPlacement != null) {
                sortItemNode.setPropertyValue("nullPlace", nullPlacement);
            }
            valueSet.addChild(sortItemNode);
            V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
            dataItem.setAggregateProperty("none");
            dataItem.setRollupAggregateProperty("none");
            dataItem.setIsProjected();
            dataItem.setIsReferenced();
            dataItem.setReferencesWalked();
            dataItem.setNameProperty(newDataItem);
            V5BoundModelIdentifier exp = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
            exp.setMetadata(sortMetadata);
            exp.setIsUnwound();
            exp.setIdentifier(sortMetadata.getUniqueID());
            dataItem.addChild(exp);
            v5Selection.addChild(dataItem);
        }
    }

    protected String getSortDirection(MoserSortItem sortItem, String explicitSortDirection) {
        String sortDirection = null;
        if (sortItem.getSort() != null) {
            sortDirection = sortItem.getSort().toString();
        }
        if (sortDirection == null) {
            sortDirection = "ascending";
        }
        if ("descending".equals(explicitSortDirection)) {
            sortDirection = "ascending".equals(sortDirection) ? "descending" : "ascending";
        }
        return sortDirection;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Boolean b = (Boolean)node.getPropertyValue(INJECT_FACET_SORT);
        if (Boolean.TRUE.equals(b)) {
            this.traceNodeCondition(false, "facet sort already applied.", trace);
            return false;
        }
        boolean status = this.checkCondition(node, environment);
        if (status) {
            this.traceNodeCondition(status, "need to inject V5DataItem for facet.", trace);
        } else {
            this.traceNodeCondition(status, "no facet sort.", trace);
        }
        return status;
    }

    protected boolean checkCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String existSortRef;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (v5QRD == null || v5QRD.getPropertyValue("tabstreamDefinition") == null) {
            return false;
        }
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItem = valueSet.getRefDataItemProperty();
        IXQEQueryNode[] v5sorts = valueSet.getChildrenOfType(101056);
        if (v5sorts.length > 1) {
            return false;
        }
        if (v5sorts.length == 1 && !refDataItem.equals(existSortRef = (String)v5sorts[0].getPropertyValue("refDataItem"))) {
            return false;
        }
        V5Query query = v5QRD.getV5Query();
        V5DataItem v5DataItem = query.getV5Selection().getDataItemByRefName(refDataItem);
        if (v5DataItem.isOLAPConstruct() || TabStreamUtil.isFactItem(v5DataItem)) {
            return false;
        }
        IXQEQueryNode expression = v5DataItem.getChild(0);
        if (expression == null || expression.getType() != 201116) {
            return false;
        }
        IMetadata exprMd = ((V5BoundModelIdentifier)expression).getMetadata();
        if (!(exprMd instanceof MoserQueryItem)) {
            return false;
        }
        MoserQueryItem qi = (MoserQueryItem)exprMd;
        IFacet facet = qi.getFacet();
        if (facet == null) {
            return false;
        }
        if (!facet.isExplicitlySetByModeler()) {
            return false;
        }
        Set<IMetadata> mds = this.getSortItemQueryItem(environment, qi);
        return !mds.isEmpty();
    }

    protected Set<IMetadata> getSortItemQueryItem(PlanningEnvironment environment, MoserQueryItem qi) {
        ISortItem[] sortItems;
        HashSet<IMetadata> rt = new HashSet<IMetadata>();
        IFacet facet = qi.getFacet();
        for (ISortItem si : sortItems = facet.getSortItems()) {
            MoserSortItem sortItem = (MoserSortItem)si;
            String ref = sortItem.getRefObject();
            if (ref == null) continue;
            String[] parts = ref.split("\\.");
            String refName = ref;
            if (parts.length > 1) {
                refName = parts[parts.length - 1];
            }
            if (refName.equals(qi.getName())) {
                rt.add(qi);
                continue;
            }
            IMetadata mi = this.bindSortReference(environment, ref, qi.getQuerySubject());
            if (mi == null) continue;
            rt.add(mi);
        }
        return rt;
    }

    protected IMetadata bindSortReference(PlanningEnvironment environment, String ref, IQuerySubject qs) {
        environment.pushSymbolTable(new SymbolTableForQS(qs, null, true));
        IMetadata sortMetadata = environment.getMetadataConnection().bindMetadataReference(ref);
        environment.popSymbolTable();
        return sortMetadata;
    }
}

