/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class OptimizeDetailFilterForDetailCrosstab
extends Transformation {
    public OptimizeDetailFilterForDetailCrosstab() {
        this.mName = "Optimize Detail Filter for Detail Crosstab.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, (V5QueryResultDefinition)node);
        IXQEQueryNode[] detailFilters = env.mV5Query.getV5DetailFilters();
        env.mV5Query.removeProperty(Governors.ExecutionOptimization.ALLROWS.toString());
        for (IXQEQueryNode aFilter : detailFilters) {
            V5DetailFilter detailFilter = (V5DetailFilter)aFilter;
            if (detailFilter.getPropertyValue("masterDetailDFilter") != Boolean.TRUE) continue;
            IXQEQueryNode[] expr = detailFilter.getChildren();
            V5DataItem dataItem = null;
            V5BoundParameter param = null;
            if ((expr = expr[0].getChildren())[0].getType() == 101003) {
                dataItem = (V5DataItem)expr[0];
                param = (V5BoundParameter)expr[1];
            } else {
                dataItem = (V5DataItem)expr[1];
                param = (V5BoundParameter)expr[0];
            }
            V5DataItem tabDataItem = (V5DataItem)env.mFactory.deepCopyNode(dataItem);
            tabDataItem.setPropertyValue("itemMDOptimize", Boolean.TRUE);
            TabStreamUtil.addItemToListQuery(env, tabDataItem);
            ArrayList<Object> prop = (ArrayList<String>)env.mTabSelection.getPropertyValue("scope");
            if (prop == null) {
                prop = new ArrayList<String>();
                env.mTabSelection.setPropertyValue("scope", prop);
            }
            prop.add(tabDataItem.getNameProperty());
            prop = env.mCube.getCubeParameters();
            if (prop == null) {
                prop = new ArrayList();
                env.mCube.setCubeParameters(prop);
            }
            prop.add(param.getParameterName());
            aFilter.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        Object tabDef = v5QRD.getPropertyValue("tabstreamDefinition");
        boolean bCheck = false;
        if (tabDef != null) {
            V5Source src = v5Query.getV5Source();
            Iterator<MasterDetailLink> cube = src.getPropertyValue("needTabularStream");
            bCheck = cube instanceof CubeWrapper ? ((CubeWrapper)((Object)cube)).getCubeParameters() == null : false;
        }
        if (bCheck) {
            MasterDetailLink firstLink;
            List<MasterDetailLink> mdlinks = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider().getMasterDetailLinksForDetailQrd(v5QRD.getName());
            bCheck = !mdlinks.isEmpty();
            for (MasterDetailLink link : mdlinks) {
                if (!link.isParameterLink()) continue;
                bCheck = false;
                break;
            }
            if (bCheck && !(firstLink = mdlinks.get(0)).isSingleQuery()) {
                String mstQueryName = firstLink.getMasterQueryName();
                V5QuerySet querySet = (V5QuerySet)v5QRD.getAncestorOfType(101002);
                V5Query mstQuery = querySet.getV5Query(mstQueryName);
                boolean bl = bCheck = mstQuery.getV5DetailFilters().length == 0;
            }
        }
        if (bCheck) {
            boolean bl = bCheck = Boolean.TRUE == v5Query.getPropertyValue(Governors.ExecutionOptimization.ALLROWS.toString());
        }
        if (bCheck) {
            bCheck = false;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (configuration != null && configuration.getBooleanProperty("masterdetail.relationalcrosstab.optimize[@enabled]", true)) {
                bCheck = true;
            }
        }
        if (bCheck) {
            IXQEQueryNode[] detailFilters;
            boolean bHasLinkFilter = false;
            for (IXQEQueryNode aFilter : detailFilters = v5Query.getV5DetailFilters()) {
                V5DetailFilter detailFilter = (V5DetailFilter)aFilter;
                if (detailFilter.getPropertyValue("masterDetailDFilter") != Boolean.TRUE) continue;
                bHasLinkFilter = true;
                if (detailFilter.getPostAutoAggregation()) {
                    bCheck = false;
                    break;
                }
                IXQEQueryNode[] expr = detailFilter.getChildren();
                if (expr.length != 1 || expr[0].getType() != 201013 || ((V5ComparisonExpression)expr[0]).getSubType() != 2) {
                    bCheck = false;
                    break;
                }
                V5DataItem dataItem = null;
                if ((expr = expr[0].getChildren())[0].getType() == 101003) {
                    if (expr[1].getType() == 201127) {
                        dataItem = (V5DataItem)expr[0];
                    }
                } else if (expr[1].getType() == 101003 && expr[0].getType() == 201127) {
                    dataItem = (V5DataItem)expr[1];
                }
                if (dataItem != null && !TabStreamUtil.isFactItem(dataItem)) continue;
                bCheck = false;
                break;
            }
            if (bCheck) {
                bCheck = bHasLinkFilter;
            }
        }
        if (bCheck) {
            this.traceNodeCondition(bCheck, "need to optimize detail filter for detail crosstab.", trace);
        } else {
            this.traceNodeCondition(bCheck, "can't optimize detail filter for detail crosstab.", trace);
        }
        return bCheck;
    }
}

