/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;

public final class RefineAutomaticMixedDMRRel
extends Transformation {
    public RefineAutomaticMixedDMRRel() {
        this.mName = "Resolve Automatic in Mixed DMR and Relational.";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem = (V5DataItem)node;
        String aggr = v5DataItem.getAggregateProperty();
        String rollUp = v5DataItem.getRollupAggregateProperty();
        RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC;
        if (aggr != null) {
            aggrType = RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggr);
        }
        RefineAutomaticXtab.AggrTypeEnum rollUpType = RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC;
        if (rollUp != null) {
            rollUpType = RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(rollUp);
        }
        if (aggrType == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
            aggrType = RefineAutomaticXtab.determineAggrType(environment, node.getChild(0), aggrType);
            v5DataItem.setAggregateProperty(aggrType.getV5Name());
        }
        if (rollUpType == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
            rollUpType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, rollUpType);
            v5DataItem.setRollupAggregateProperty(rollUpType.getV5Name());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query != null && (b = query.isMixedDMRRelational()) != null && b.booleanValue()) {
            V5DataItem item = (V5DataItem)node;
            String aggr = item.getAggregateProperty();
            String rollUp = item.getRollupAggregateProperty();
            if (aggr == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggr) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
                status = true;
            } else if (rollUp == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(rollUp) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "need to refine automatic.", trace);
        } else {
            this.traceNodeCondition(status, "don't refine automatic.", trace);
        }
        return status;
    }
}

