/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import java.util.ArrayList;

public final class SetTNodeInformationInSlicerFilter
extends Transformation {
    public SetTNodeInformationInSlicerFilter() {
        this.mName = "Set TNode Information in slicer and/or filter.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        MixedDMRRelUtil.MixedDMRRelParam param = MixedDMRRelUtil.createParam();
        param.env = environment;
        param.factory = environment.getNodeFactory();
        param.selection = query.getV5Selection();
        MixedDMRRelUtil.collectWrappedMeasuresAndLevels(param);
        ArrayList<IXQEQueryNode> nodes = this.getUnResolvedTNodesInSlicerFilter(node);
        for (IXQEQueryNode n : nodes) {
            IXQEQueryNode[] tnodes;
            for (IXQEQueryNode tnode : tnodes = n.getDescendantsOfType(601024, false)) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                String[] aggrRollUp = new String[]{null, null, null};
                tp = MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp);
                if (tp == 0) {
                    MixedDMRRelUtil.wrapToMeasure(relOLAPDeco, param, aggrRollUp);
                    continue;
                }
                MixedDMRRelUtil.wrapToNewOrExistLevel(relOLAPDeco, param, aggrRollUp[2]);
            }
        }
    }

    protected ArrayList<IXQEQueryNode> getUnResolvedTNodesInSlicerFilter(IXQEQueryNode node) {
        IXQEQueryNode[] summaryFilters;
        IXQEQueryNode[] detailFilters;
        IXQEQueryNode[] v5Slicers;
        ArrayList<IXQEQueryNode> r = new ArrayList<IXQEQueryNode>();
        V5Query query = (V5Query)node;
        for (IXQEQueryNode slicer : v5Slicers = query.getV5Slicers()) {
            IXQEQueryNode[] tnodes = slicer.getDescendantsOfType(601024, false);
            boolean hasUnResolvedTNodes = false;
            for (IXQEQueryNode tnode : tnodes) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                hasUnResolvedTNodes = true;
                break;
            }
            if (!hasUnResolvedTNodes) continue;
            r.add(slicer);
        }
        for (IXQEQueryNode aFilter : detailFilters = query.getV5DetailFilters()) {
            IXQEQueryNode[] tnodes = aFilter.getDescendantsOfType(601024, false);
            boolean hasUnResolvedTNodes = false;
            for (IXQEQueryNode tnode : tnodes) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                hasUnResolvedTNodes = true;
                break;
            }
            if (!hasUnResolvedTNodes) continue;
            r.add(aFilter);
        }
        for (IXQEQueryNode aSumFilter : summaryFilters = query.getV5SummaryFilters()) {
            IXQEQueryNode[] tnodes = aSumFilter.getDescendantsOfType(601024, false);
            boolean hasUnResolvedTNodes = false;
            for (IXQEQueryNode tnode : tnodes) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                hasUnResolvedTNodes = true;
                break;
            }
            if (!hasUnResolvedTNodes) continue;
            r.add(aSumFilter);
        }
        return r;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Boolean b = ((V5Query)node).isMixedDMRRelational();
        if (b != null && b.booleanValue()) {
            ArrayList<IXQEQueryNode> tnodes = this.getUnResolvedTNodesInSlicerFilter(node);
            boolean bl = status = !tnodes.isEmpty();
        }
        if (status) {
            this.traceNodeCondition(status, "need to set TNode information in slicer and / or filter.", trace);
        } else {
            this.traceNodeCondition(status, "don't set TNode information in slicer and / or filter.", trace);
        }
        return status;
    }
}

